/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftservezone.allay.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.minecraftservezone.allay.entity.AIItemSearch;
import com.minecraftservezone.allay.entity.AINoteBlockSearch;
import com.minecraftservezone.allay.entity.AIRandomFly;
import com.minecraftservezone.allay.entity.AITiredFromSearching;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNote;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityAllay
extends EntityFlying {
    private static final DataParameter<Integer> GLOW = EntityDataManager.func_187226_a(EntityAllay.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityAllay.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);
    @Nullable
    BlockPos savedNoteBlockPos;
    public float dancing;
    public int ticksWithoutItemSinceExitingNoteBlock;

    public EntityAllay(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.55f, 0.75f);
        this.field_70765_h = new AllayMoveHelper(this);
    }

    boolean isNoteBlockValid() {
        if (!this.hasNoteBlock()) {
            return false;
        }
        Block block = this.field_70170_p.func_180495_p(this.savedNoteBlockPos).func_177230_c();
        if (!(block instanceof BlockNote)) {
            this.savedNoteBlockPos = null;
        }
        return block instanceof BlockNote;
    }

    public void setSavedNoteBlockPos(BlockPos p_27877_) {
        this.savedNoteBlockPos = p_27877_;
    }

    @VisibleForTesting
    public boolean hasNoteBlock() {
        return this.savedNoteBlockPos != null;
    }

    @Nullable
    @VisibleForTesting
    public BlockPos getNoteBlockPos() {
        return this.savedNoteBlockPos;
    }

    public float getDancingTick() {
        return this.dancing;
    }

    public void func_70103_a(byte id) {
        if (id == 56) {
            this.dancing = 100.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    private static float[] createAllayColor(EnumDyeColor p_192020_0_) {
        float[] afloat = p_192020_0_.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(GLOW, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.hasNoteBlock()) {
            compound.func_74782_a("NoteBlockPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.getNoteBlockPos()));
        }
        compound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
        compound.func_74768_a("Glow", this.getGlow());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.savedNoteBlockPos = null;
        if (compound.func_150297_b("NoteBlockPos", 99)) {
            this.savedNoteBlockPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("NoteBlockPos"));
        }
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)compound.func_74771_c("Color")));
        this.setGlow(compound.func_74771_c("Glow"));
    }

    public int getGlow() {
        return (Integer)this.field_70180_af.func_187225_a(GLOW);
    }

    public void setGlow(int color) {
        this.field_70180_af.func_187227_b(GLOW, (Object)color);
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public static EnumDyeColor getRandomAllayColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return EnumDyeColor.BLACK;
        }
        if (i < 10) {
            return EnumDyeColor.GRAY;
        }
        if (i < 15) {
            return EnumDyeColor.SILVER;
        }
        if (i < 18) {
            return EnumDyeColor.BROWN;
        }
        return random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE;
    }

    public int func_70070_b() {
        if (this.getGlow() == 15) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }

    public float func_70013_c() {
        if (this.getGlow() == 15) {
            return 1.0f;
        }
        return super.func_70070_b();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setFleeceColor(EnumDyeColor.LIGHT_BLUE);
        return livingdata;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_190931_a) {
            if (this.func_190630_a(EntityEquipmentSlot.MAINHAND) && !this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.func_184614_ca(), 1.0f);
                this.func_70099_a(this.func_184592_cb(), 1.0f);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, player.func_184586_b(hand));
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, player.func_184586_b(hand));
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor enumdyecolor;
            if (Items.field_151100_aR.getMetadata(itemstack) == 0) {
                this.setGlow(0);
            }
            if ((enumdyecolor = EnumDyeColor.func_176766_a((int)itemstack.func_77960_j())) != this.getFleeceColor()) {
                this.setFleeceColor(enumdyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
        } else {
            if (itemstack.func_77973_b() == Items.field_151114_aO) {
                this.setGlow(15);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            ItemStack itemFromPlayersMainHand = new ItemStack(itemstack.func_77973_b(), 1);
            if (this.func_190630_a(EntityEquipmentSlot.MAINHAND)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.func_184614_ca(), 1.0f);
                    this.func_70099_a(this.func_184592_cb(), 1.0f);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemFromPlayersMainHand);
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemFromPlayersMainHand);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AINoteBlockSearch(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIItemSearch(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITiredFromSearching(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILookAround(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public float func_70047_e() {
        return 0.6f;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.func_190630_a(EntityEquipmentSlot.MAINHAND)) {
                this.resetTicksWithoutItemSinceExitingNoteBlock();
            }
            if (this.func_190630_a(EntityEquipmentSlot.MAINHAND)) {
                ++this.ticksWithoutItemSinceExitingNoteBlock;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.hasNoteBlock() && this.func_174818_b(this.savedNoteBlockPos) < 5.0 && this.dancing == 0.0f) {
            this.dancing = 100.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)56);
        }
        if (this.getDancingTick() > 0.0f) {
            if (this.dancing % 15.0f == 0.0f) {
                this.spawnFluidParticle(this.field_70170_p, this.field_70165_t - (double)0.3f, this.field_70163_u + (double)0.3f, this.field_70161_v - (double)0.3f, this.field_70161_v + (double)0.3f, this.field_70163_u + 0.5, EnumParticleTypes.NOTE);
            }
            this.dancing -= 1.0f;
        }
        super.func_70071_h_();
    }

    private void spawnFluidParticle(World p_27780_, double p_27781_, double p_27782_, double p_27783_, double p_27784_, double p_27785_, EnumParticleTypes p_27786_) {
        p_27780_.func_175688_a(p_27786_, MathHelper.func_151238_b((double)p_27780_.field_73012_v.nextDouble(), (double)p_27781_, (double)p_27782_), p_27785_, MathHelper.func_151238_b((double)p_27780_.field_73012_v.nextDouble(), (double)p_27783_, (double)p_27784_), 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean isTiredOfLookingForItem() {
        return this.ticksWithoutItemSinceExitingNoteBlock > 2400;
    }

    public void resetTicksWithoutItemSinceExitingNoteBlock() {
        this.ticksWithoutItemSinceExitingNoteBlock = 0;
    }

    static {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            DYE_TO_RGB.put(enumdyecolor, EntityAllay.createAllayColor(enumdyecolor));
        }
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{0.9019608f, 0.9019608f, 0.9019608f});
    }

    static class AIRandomFlyNoteBlockSearchAndItemSearch
    extends EntityAIBase {
        private final EntityAllay parentEntity;
        public Predicate<EntityItem> ALLOWED_ITEMS;

        public AIRandomFlyNoteBlockSearchAndItemSearch(EntityAllay allay) {
            this.parentEntity = allay;
        }

        public boolean func_75250_a() {
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            return true;
        }

        public boolean func_75253_b() {
            return !this.parentEntity.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            if (!this.parentEntity.field_70170_p.field_72995_K) {
                BlockPos isNoteBlockNear = this.searchForBlockInDistance(this.parentEntity, 40, 40, 40);
                if (!this.parentEntity.hasNoteBlock()) {
                    if (isNoteBlockNear == null) {
                        this.randomWandering();
                    } else {
                        this.parentEntity.savedNoteBlockPos = isNoteBlockNear;
                        this.parentEntity.func_70605_aq().func_75642_a((double)isNoteBlockNear.func_177958_n() + 0.5, (double)isNoteBlockNear.func_177956_o() + 2.0, (double)isNoteBlockNear.func_177952_p() + 0.5, (double)0.6f);
                    }
                } else if (this.parentEntity.isNoteBlockValid()) {
                    if (this.parentEntity.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                        return;
                    }
                    if (this.parentEntity.isTiredOfLookingForItem()) {
                        if (this.parentEntity.func_70092_e(this.parentEntity.savedNoteBlockPos.func_177958_n(), this.parentEntity.savedNoteBlockPos.func_177956_o(), this.parentEntity.savedNoteBlockPos.func_177952_p()) < 20.0) {
                            this.parentEntity.resetTicksWithoutItemSinceExitingNoteBlock();
                            if (!this.parentEntity.field_70170_p.field_72995_K) {
                                this.parentEntity.func_70099_a(this.parentEntity.func_184592_cb(), -1.0f);
                                this.parentEntity.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                            }
                        }
                        this.parentEntity.func_70605_aq().func_75642_a((double)this.parentEntity.savedNoteBlockPos.func_177958_n() + 0.5, (double)this.parentEntity.savedNoteBlockPos.func_177956_o() + 2.0, (double)this.parentEntity.savedNoteBlockPos.func_177952_p() + 0.5, 1.0);
                    } else if (!this.searchForItemInDistance(this.parentEntity, 40.0, 40.0, 40.0)) {
                        this.randomWandering();
                    }
                } else {
                    return;
                }
            }
        }

        public void randomWandering() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.6);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean searchForItemInDistance(EntityAllay entities, double posx, double posy, double posz) {
            int whichNumberFromArrayShouldBeUSed = 0;
            this.ALLOWED_ITEMS = p_29133_ -> {
                ItemStack itemstack = p_29133_.func_92059_d();
                return itemstack.func_77969_a(entities.func_184582_a(EntityEquipmentSlot.MAINHAND)) && p_29133_.func_70089_S() && !p_29133_.func_174874_s();
            };
            List list = entities.field_70170_p.func_175647_a(EntityItem.class, entities.func_174813_aQ().func_72314_b(0.0, 0.0, 0.0), this.ALLOWED_ITEMS);
            int i = 1;
            block0: while ((double)i < posx + 1.0) {
                list = entities.field_70170_p.func_175647_a(EntityItem.class, entities.func_174813_aQ().func_72314_b((double)(i - 1), (double)(i - 1), (double)(i - 1)), this.ALLOWED_ITEMS);
                if (!list.isEmpty()) {
                    for (int listnumber = 0; listnumber < list.size(); ++listnumber) {
                        EntityItem currentX = (EntityItem)list.get(listnumber);
                        if (!(currentX.func_174818_b(entities.savedNoteBlockPos) < 20.0)) break block0;
                        list.remove(listnumber);
                    }
                }
                ++i;
            }
            if (list.isEmpty()) {
                this.randomWandering();
                return false;
            }
            int listnumber = 0;
            while (listnumber < list.size()) {
                whichNumberFromArrayShouldBeUSed = listnumber++;
            }
            if (((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_70068_e((Entity)entities) < 10.0 && ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_174818_b(entities.savedNoteBlockPos) > 20.0) {
                ItemStack stack = new ItemStack(((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_77973_b(), ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_190916_E());
                if (!this.parentEntity.func_184592_cb().func_190926_b()) {
                    stack = new ItemStack(((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_77973_b(), ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_190916_E() + this.parentEntity.func_184592_cb().func_190916_E());
                }
                if (this.parentEntity.func_184592_cb().func_190916_E() >= ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_77973_b().func_77639_j()) {
                    this.parentEntity.ticksWithoutItemSinceExitingNoteBlock = 2401;
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.parentEntity.savedNoteBlockPos.func_177958_n() + 0.5, (double)this.parentEntity.savedNoteBlockPos.func_177956_o() + 4.0, (double)this.parentEntity.savedNoteBlockPos.func_177952_p() + 0.5, 1.0);
                }
                this.parentEntity.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_70106_y();
                return false;
            }
            if (this.parentEntity.func_184592_cb().func_190916_E() >= ((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_92059_d().func_77973_b().func_77639_j()) {
                this.parentEntity.ticksWithoutItemSinceExitingNoteBlock = 2401;
                this.parentEntity.func_70605_aq().func_75642_a((double)this.parentEntity.savedNoteBlockPos.func_177958_n() + 0.5, (double)this.parentEntity.savedNoteBlockPos.func_177956_o() + 4.0, (double)this.parentEntity.savedNoteBlockPos.func_177952_p() + 0.5, 1.0);
                return true;
            }
            if (((EntityItem)list.get(whichNumberFromArrayShouldBeUSed)).func_174818_b(entities.savedNoteBlockPos) > 20.0) {
                this.parentEntity.func_184595_k(((EntityItem)list.get((int)whichNumberFromArrayShouldBeUSed)).field_70165_t, ((EntityItem)list.get((int)whichNumberFromArrayShouldBeUSed)).field_70163_u, ((EntityItem)list.get((int)whichNumberFromArrayShouldBeUSed)).field_70161_v);
            }
            this.randomWandering();
            return true;
        }

        public BlockPos searchForBlockInDistance(EntityAllay entity, int posx, int posy, int posz) {
            BlockPos blockpos = entity.func_180425_c();
            for (int x = -posx; x < posx + 1; ++x) {
                for (int y = -posy; y < posy + 1; ++y) {
                    for (int z = -posz; z < posz + 1; ++z) {
                        if (entity.field_70170_p.func_180495_p(blockpos.func_177982_a(x, y, z)).func_177230_c() != Blocks.field_150323_B) continue;
                        return blockpos.func_177982_a(x, y, z);
                    }
                }
            }
            return null;
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityAllay parentEntity;

        public AILookAround(EntityAllay allay) {
            this.parentEntity = allay;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AllayMoveHelper
    extends EntityMoveHelper {
        private final EntityAllay parentEntity;
        private int courseChangeCooldown;

        public AllayMoveHelper(EntityAllay ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        this.parentEntity.func_184595_k(d0, d1, d2);
                        this.parentEntity.func_70605_aq().func_75642_a(d0, d3 + 5.0, d2, 1.0);
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

