/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.libraryferret.conf;

import com.command_block.libraryferret.conf.Props;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.minecraftforge.fml.loading.FMLPaths;

public class Configuration {
    private static final List<Configuration> INSTANCES = new ArrayList<Configuration>();
    private final String identifier;
    private final Properties properties;
    private final String propertiesPath;
    public List<Props> propsRegistre = new ArrayList<Props>();

    private Configuration(String mod_id) {
        this.identifier = mod_id;
        this.propertiesPath = FMLPaths.CONFIGDIR.get().toString() + "/" + mod_id + "_general_.properties";
        this.properties = new Properties();
        this.load();
    }

    public static Configuration get(String mod_id) {
        for (Configuration c : INSTANCES) {
            if (!c.identifier.equals(mod_id)) continue;
            return c;
        }
        Configuration newInstanceSingleton = new Configuration(mod_id);
        if (INSTANCES.add(newInstanceSingleton)) {
            return newInstanceSingleton;
        }
        throw new NullPointerException("Creata a new instance singleton is not possible for " + mod_id + ", return null singleton !");
    }

    public void load() {
        try {
            this.properties.load(new FileInputStream(this.propertiesPath));
        }
        catch (Exception e) {
            System.err.println("Failed to load properties");
        }
    }

    public void save() {
        for (Props e : this.propsRegistre) {
            this.properties.setProperty(e.getKey(), this.properties.getProperty(e.getKey(), e.getDefaultValue()));
        }
        try {
            this.properties.store(new FileWriter(this.propertiesPath), "need help ? http://adfoc.us/70606381270177");
        }
        catch (IOException e) {
            System.err.println("Failed to store properties");
        }
    }

    public static void registry(String mod_id, Props ... props) {
        Configuration instance = Configuration.get(mod_id);
        for (Props v : props) {
            instance.propsRegistre.add(v);
        }
        instance.save();
    }

    public String getStringOrDefault(Props props) {
        return this.properties.getProperty(props.getKey(), props.getDefaultValue());
    }

    public boolean getBoolOrDefault(Props props) {
        return "true".equalsIgnoreCase(this.getStringOrDefault(props));
    }

    public int getNumberOrDefault(Props props) {
        try {
            return Integer.parseInt(this.getStringOrDefault(props));
        }
        catch (Exception e) {
            try {
                return Integer.parseInt(props.getDefaultValue());
            }
            catch (Exception e2) {
                System.err.println(e2);
                return 0;
            }
        }
    }
}

