/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudio.awesomedungeonend;

import com.command_block.libraryferret.conf.Configuration;
import com.command_block.libraryferret.conf.Props;
import com.command_block.libraryferret.patreon.Patreon;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jtorleonstudio.awesomedungeonend.ConfiguredStructures;
import com.jtorleonstudio.awesomedungeonend.SimpleEndStructure;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="awesomedungeonend")
public class Main {
    public static final String MOD_ID = "awesomedungeonend";
    public static final Logger LOGGER = LogManager.getLogger((String)"awesomedungeonend");
    public static final DeferredRegister<StructureFeature<?>> DEF;
    public static final String CASTLE_EVOKER_ID = "end_castle_evoker";
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> CASTLE_EVOKER;
    public static final String HARDCASTLE_ID = "end_hardcastle";
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> HARDCASTLE;
    public static final String PALACE_ID = "end_palace";
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> PALACE;
    public static final String PILL_ID = "end_pill";
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> PILL;
    public static final String PYRAMID_ID = "end_pyramid";
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> PYRAMID;
    private static Method GETCODEC_METHOD;

    public Main() {
        Configuration.get((String)MOD_ID);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEF.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Main.setupMapSpacingAndLand((StructureFeature)CASTLE_EVOKER.get(), new StructureFeatureConfiguration(100, 50, 154835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)HARDCASTLE.get(), new StructureFeatureConfiguration(100, 50, 254835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PALACE.get(), new StructureFeatureConfiguration(100, 50, 354835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PILL.get(), new StructureFeatureConfiguration(100, 50, 454835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PYRAMID.get(), new StructureFeatureConfiguration(100, 50, 554835856), true);
            ConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if (Main.isBiome(event, Biomes.f_48164_)) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructures.CFG_CASTLE_EVOKER);
            event.getGeneration().getStructures().add(() -> ConfiguredStructures.CFG_HARDCASTLE);
            event.getGeneration().getStructures().add(() -> ConfiguredStructures.CFG_PALACE);
            event.getGeneration().getStructures().add(() -> ConfiguredStructures.CFG_PILL);
            event.getGeneration().getStructures().add(() -> ConfiguredStructures.CFG_PYRAMID);
        }
    }

    @SafeVarargs
    public static boolean isBiome(BiomeLoadingEvent context, ResourceKey<Biome> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getName().equals((Object)key.m_135782_()));
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.m_7726_().f_8328_, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.m_7726_().m_8481_() instanceof FlatLevelSource && serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tmpMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(serverWorld.m_7726_().f_8328_.m_62205_().m_64590_());
            tmpMap.putIfAbsent((StructureFeature)CASTLE_EVOKER.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)CASTLE_EVOKER.get()));
            tmpMap.putIfAbsent((StructureFeature)HARDCASTLE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)HARDCASTLE.get()));
            tmpMap.putIfAbsent((StructureFeature)PALACE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PALACE.get()));
            tmpMap.putIfAbsent((StructureFeature)PILL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PILL.get()));
            tmpMap.putIfAbsent((StructureFeature)PYRAMID.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PILL.get()));
            serverWorld.m_7726_().f_8328_.m_62205_().f_64582_ = tmpMap;
        }
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration StructureFeatureConfiguration2, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)StructureFeatureConfiguration2).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, StructureFeatureConfiguration2);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, StructureFeatureConfiguration2);
            }
        });
    }

    public static final boolean hasPatreon() {
        boolean hasPatreon = Configuration.get((String)MOD_ID).getStringOrDefault(Patreon.PROPERTIES).equals("RSszddJBQMDuTUitzGkfxDdRk2piotV4YFdQs0buwb");
        if (hasPatreon) {
            LOGGER.info("Hi my friend! The patreon functions are enabled");
        } else {
            LOGGER.info("Hi my friend, unfortunately the key is not correct! The patreon functions are not activated");
        }
        return hasPatreon;
    }

    static {
        Configuration.registry((String)MOD_ID, (Props[])new Props[]{Patreon.PROPERTIES});
        DEF = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)MOD_ID);
        CASTLE_EVOKER = DEF.register(CASTLE_EVOKER_ID, () -> new SimpleEndStructure(CASTLE_EVOKER_ID));
        HARDCASTLE = DEF.register(HARDCASTLE_ID, () -> new SimpleEndStructure(HARDCASTLE_ID));
        PALACE = DEF.register(PALACE_ID, () -> new SimpleEndStructure(PALACE_ID));
        PILL = DEF.register(PILL_ID, () -> new SimpleEndStructure(PILL_ID));
        PYRAMID = DEF.register(PYRAMID_ID, () -> new SimpleEndStructure(PYRAMID_ID));
    }
}

