/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudio.awesomedungeonend;

import com.command_block.libraryferret.conf.Configuration;
import com.command_block.libraryferret.conf.Props;
import com.command_block.libraryferret.patreon.Patreon;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.jtorleonstudio.awesomedungeonend.ConfiguredStructures;
import com.jtorleonstudio.awesomedungeonend.SimpleEndStructure;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="awesomedungeonend")
public class Main {
    public static final String MOD_ID = "awesomedungeonend";
    public static final Logger LOGGER = LogManager.getLogger((String)"awesomedungeonend");
    public static final DeferredRegister<StructureFeature<?>> DEF;
    public static final String CASTLE_EVOKER_ID = "end_castle_evoker";
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> CASTLE_EVOKER;
    public static final String HARDCASTLE_ID = "end_hardcastle";
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> HARDCASTLE;
    public static final String PALACE_ID = "end_palace";
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PALACE;
    public static final String PILL_ID = "end_pill";
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PILL;
    public static final String PYRAMID_ID = "end_pyramid";
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PYRAMID;
    private static Method GETCODEC_METHOD;

    public Main() {
        Configuration.get((String)MOD_ID);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEF.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Main.setupMapSpacingAndLand((StructureFeature)CASTLE_EVOKER.get(), new StructureFeatureConfiguration(100, 50, 154835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)HARDCASTLE.get(), new StructureFeatureConfiguration(100, 50, 254835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PALACE.get(), new StructureFeatureConfiguration(100, 50, 354835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PILL.get(), new StructureFeatureConfiguration(100, 50, 454835856), true);
            Main.setupMapSpacingAndLand((StructureFeature)PYRAMID.get(), new StructureFeatureConfiguration(100, 50, 554835856), true);
            ConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings config = chunkGenerator.m_62205_();
            HashMap<StructureFeature, HashMultimap> map = new HashMap<StructureFeature, HashMultimap>();
            ImmutableSet b = ImmutableSet.builder().add((Object)Biomes.f_48164_).build();
            b.forEach(v -> {
                if (v == Biomes.f_48164_) {
                    Main.associateBiomeToConfiguredStructure(map, ConfiguredStructures.CFG_CASTLE_EVOKER, (ResourceKey<Biome>)v);
                    Main.associateBiomeToConfiguredStructure(map, ConfiguredStructures.CFG_HARDCASTLE, (ResourceKey<Biome>)v);
                    Main.associateBiomeToConfiguredStructure(map, ConfiguredStructures.CFG_PALACE, (ResourceKey<Biome>)v);
                    Main.associateBiomeToConfiguredStructure(map, ConfiguredStructures.CFG_PILL, (ResourceKey<Biome>)v);
                    Main.associateBiomeToConfiguredStructure(map, ConfiguredStructures.CFG_PYRAMID, (ResourceKey<Biome>)v);
                }
            });
            ImmutableMap.Builder toMultiMap = ImmutableMap.builder();
            config.f_189361_.entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)toMultiMap).put(arg_0));
            map.forEach((key, value) -> toMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            config.f_189361_ = toMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tmpMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(config.m_64590_());
            tmpMap.putIfAbsent((StructureFeature)CASTLE_EVOKER.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)CASTLE_EVOKER.get()));
            tmpMap.putIfAbsent((StructureFeature)HARDCASTLE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)HARDCASTLE.get()));
            tmpMap.putIfAbsent((StructureFeature)PALACE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PALACE.get()));
            tmpMap.putIfAbsent((StructureFeature)PILL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PILL.get()));
            tmpMap.putIfAbsent((StructureFeature)PYRAMID.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PILL.get()));
            config.f_64582_ = tmpMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureFeatureConfiguration, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureFeatureConfiguration).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureFeatureConfiguration);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureFeatureConfiguration);
            }
        });
    }

    public static final boolean hasPatreon() {
        boolean hasPatreon = Configuration.get((String)MOD_ID).getStringOrDefault(Patreon.PROPERTIES).equals("RSszddJBQMDuTUitzGkfxDdRk2piotV4YFdQs0buwb");
        if (hasPatreon) {
            LOGGER.info("Hi my friend! The patreon functions are enabled");
        } else {
            LOGGER.info("Hi my friend, unfortunately the key is not correct! The patreon functions are not activated");
        }
        return hasPatreon;
    }

    static {
        Configuration.registry((String)MOD_ID, (Props[])new Props[]{Patreon.PROPERTIES});
        DEF = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)MOD_ID);
        CASTLE_EVOKER = DEF.register(CASTLE_EVOKER_ID, () -> new SimpleEndStructure(CASTLE_EVOKER_ID));
        HARDCASTLE = DEF.register(HARDCASTLE_ID, () -> new SimpleEndStructure(HARDCASTLE_ID));
        PALACE = DEF.register(PALACE_ID, () -> new SimpleEndStructure(PALACE_ID));
        PILL = DEF.register(PILL_ID, () -> new SimpleEndStructure(PILL_ID));
        PYRAMID = DEF.register(PYRAMID_ID, () -> new SimpleEndStructure(PYRAMID_ID));
    }
}

