/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks;

import com.wildcard.buddycards.blocks.tiles.CardDisplayTile;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class CardDisplayBlock
extends Block {
    public static final DirectionProperty DIR = BlockStateProperties.field_208157_J;
    protected static final VoxelShape NSHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ESHAPE = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SSHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WSHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    final String NEEDED_MOD;

    public CardDisplayBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIR, (Comparable)Direction.NORTH));
        this.NEEDED_MOD = "";
    }

    public CardDisplayBlock(String neededMod) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIR, (Comparable)Direction.NORTH));
        this.NEEDED_MOD = neededMod;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)DIR);
        switch (direction) {
            default: {
                return NSHAPE;
            }
            case EAST: {
                return ESHAPE;
            }
            case SOUTH: {
                return SSHAPE;
            }
            case WEST: 
        }
        return WSHAPE;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case CLOCKWISE_90: {
                switch ((Direction)state.func_177229_b((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case EAST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case WEST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.NORTH);
                    }
                }
            }
            case CLOCKWISE_180: {
                switch ((Direction)state.func_177229_b((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case EAST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case SOUTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case WEST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.EAST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((Direction)state.func_177229_b((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case EAST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case WEST: {
                        return (BlockState)state.func_206870_a((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DIR, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIR});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CardDisplayTile) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CardDisplayTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        int slot = this.getSlot((Direction)state.func_177229_b((Property)DIR), hit.func_216347_e());
        if (world.func_175625_s(pos) instanceof CardDisplayTile) {
            CardDisplayTile displayTile = (CardDisplayTile)world.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == BuddycardsItems.BUDDYSTEEL_KEY.get()) {
                if (displayTile.isLocked()) {
                    if (displayTile.toggleLock(player.func_110124_au())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_display.unlock"), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_display.fail_unlock"), true);
                    }
                } else {
                    displayTile.toggleLock(player.func_110124_au());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_display.lock"), true);
                }
            } else if (displayTile.isLocked()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_display.lock"), true);
            } else if (displayTile.getCardInSlot(slot).func_77973_b() instanceof CardItem) {
                ItemStack oldCard = displayTile.getCardInSlot(slot);
                if (stack.func_77973_b() instanceof CardItem) {
                    ItemStack card = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
                    card.func_77982_d(stack.func_77978_p());
                    displayTile.putCardInSlot(card, slot);
                    stack.func_190918_g(1);
                } else {
                    displayTile.putCardInSlot(ItemStack.field_190927_a, slot);
                }
                if (!player.func_191521_c(oldCard)) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)oldCard);
                }
            } else if (stack.func_77973_b() instanceof CardItem) {
                ItemStack card = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
                card.func_77982_d(stack.func_77978_p());
                displayTile.putCardInSlot(card, slot);
                stack.func_190918_g(1);
            }
        }
        world.func_175666_e(pos, (Block)this);
        return ActionResultType.SUCCESS;
    }

    private int getSlot(Direction dir, Vector3d hit) {
        hit = new Vector3d((hit.field_72450_a < 0.0 ? hit.field_72450_a - Math.floor(hit.field_72450_a) : hit.field_72450_a) % 1.0, (hit.field_72448_b < 0.0 ? hit.field_72448_b - Math.floor(hit.field_72448_b) : hit.field_72448_b) % 1.0, (hit.field_72449_c < 0.0 ? hit.field_72449_c - Math.floor(hit.field_72449_c) : hit.field_72449_c) % 1.0);
        if (hit.field_72448_b > 0.5) {
            if (dir == Direction.NORTH) {
                if (hit.field_72450_a < 0.3333333432674408) {
                    return 1;
                }
                if (hit.field_72450_a < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.EAST) {
                if (hit.field_72449_c < 0.3333333432674408) {
                    return 1;
                }
                if (hit.field_72449_c < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.SOUTH) {
                if (hit.field_72450_a > 0.6666666865348816) {
                    return 1;
                }
                if (hit.field_72450_a > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.WEST) {
                if (hit.field_72449_c > 0.6666666865348816) {
                    return 1;
                }
                if (hit.field_72449_c > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
        } else {
            if (dir == Direction.NORTH) {
                if (hit.field_72450_a < 0.3333333432674408) {
                    return 4;
                }
                if (hit.field_72450_a < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.EAST) {
                if (hit.field_72449_c < 0.3333333432674408) {
                    return 4;
                }
                if (hit.field_72449_c < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.SOUTH) {
                if (hit.field_72450_a > 0.6666666865348816) {
                    return 4;
                }
                if (hit.field_72450_a > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.WEST) {
                if (hit.field_72449_c > 0.6666666865348816) {
                    return 4;
                }
                if (hit.field_72449_c > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
        }
        return 1;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (world.func_175625_s(pos) instanceof CardDisplayTile) {
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, ((CardDisplayTile)world.func_175625_s(pos)).getInventory());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.NEEDED_MOD != "" && !ModList.get().isLoaded(this.NEEDED_MOD)) {
            return;
        }
        super.func_149666_a(group, items);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        CardDisplayTile displayTile = (CardDisplayTile)world.func_175625_s(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        CardDisplayTile displayTile = (CardDisplayTile)world.func_175625_s(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof CardDisplayTile) {
            return ((CardDisplayTile)tileentity).getCardsAmt();
        }
        return 0;
    }
}

