/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks;

import com.wildcard.buddycards.blocks.tiles.CardStandTile;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class CardStandBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    final String NEEDED_MOD;

    public CardStandBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150430_aB));
        this.NEEDED_MOD = "";
    }

    public CardStandBlock(String neededMod) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150430_aB));
        this.NEEDED_MOD = neededMod;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CardStandTile) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CardStandTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_175625_s(pos) instanceof CardStandTile) {
            CardStandTile standTile = (CardStandTile)world.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == BuddycardsItems.BUDDYSTEEL_KEY.get()) {
                if (standTile.isLocked()) {
                    if (standTile.toggleLock(player.func_110124_au())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_stand.unlock"), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_stand.fail_unlock"), true);
                    }
                } else {
                    standTile.toggleLock(player.func_110124_au());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_stand.lock"), true);
                }
            } else if (standTile.isLocked()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.card_stand.lock"), true);
            } else if (standTile.getCard().func_77973_b() instanceof CardItem) {
                ItemStack oldCard = standTile.getCard();
                if (stack.func_77973_b() instanceof CardItem) {
                    ItemStack card = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
                    card.func_77982_d(stack.func_77978_p());
                    standTile.setCard(card);
                    stack.func_190918_g(1);
                } else {
                    standTile.setCard(ItemStack.field_190927_a);
                }
                if (player.func_191521_c(oldCard)) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)oldCard);
                }
                standTile.setDir((int)((double)(player.func_70079_am() * 16.0f / 360.0f) + 0.5) & 0xF);
            } else if (stack.func_77973_b() instanceof CardItem) {
                ItemStack card = new ItemStack((IItemProvider)stack.func_77973_b(), 1);
                card.func_77982_d(stack.func_77978_p());
                standTile.setCard(card);
                stack.func_190918_g(1);
                standTile.setDir((int)((double)(player.func_70079_am() * 16.0f / 360.0f) + 0.5) & 0xF);
            }
        }
        world.func_175666_e(pos, (Block)this);
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (world.func_175625_s(pos) instanceof CardStandTile) {
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)NonNullList.func_191197_a((int)1, (Object)((CardStandTile)world.func_175625_s(pos)).getCard()));
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.NEEDED_MOD != "" && !ModList.get().isLoaded(this.NEEDED_MOD)) {
            return;
        }
        super.func_149666_a(group, items);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        CardStandTile displayTile = (CardStandTile)world.func_175625_s(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        CardStandTile displayTile = (CardStandTile)world.func_175625_s(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof CardStandTile && ((CardStandTile)tileentity).getCard().func_190926_b()) {
            return 10;
        }
        return 0;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return CardStandBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos) || CardStandBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public boolean func_181623_g() {
        return true;
    }
}

