/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.items;

import com.wildcard.buddycards.BuddyCards;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.items.GummyCardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.util.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.ItemHandlerHelper;

public class PackItem
extends Item {
    final int SET_NUMBER;
    final String SPECIFIC_MOD;
    final int CARDS;
    final int SHINY_CARDS;

    public PackItem(int setNumber, String modId, int cards, int shinyCards) {
        super(new Item.Properties().func_200916_a(BuddyCards.TAB).func_200917_a(16));
        this.SET_NUMBER = setNumber;
        this.SPECIFIC_MOD = modId;
        this.CARDS = cards;
        this.SHINY_CARDS = shinyCards;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.set." + this.SET_NUMBER));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.contains." + this.SET_NUMBER));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn instanceof ServerWorld) {
            playerIn.func_184586_b(handIn).func_190918_g(1);
            NonNullList cards = NonNullList.func_191196_a();
            for (int i = 0; i < this.CARDS; ++i) {
                float rand = worldIn.field_73012_v.nextFloat();
                Rarity rarity = (double)rand < 0.5 ? Rarity.COMMON : ((double)rand < 0.8 ? Rarity.UNCOMMON : ((double)rand < 0.95 ? Rarity.RARE : Rarity.EPIC));
                ItemStack card2 = this.SET_NUMBER == 0 ? (((Boolean)ConfigManager.loadedMysteryCardsOnly.get()).booleanValue() ? new ItemStack((IItemProvider)PackItem.getRandomCardOfRarity(BuddycardsItems.LOADED_CARDS, rarity)) : new ItemStack((IItemProvider)PackItem.getRandomCardOfRarity(BuddycardsItems.ALL_CARDS, rarity))) : new ItemStack((IItemProvider)PackItem.getRandomCardOfRarity(BuddycardsItems.SETS.get((Object)Integer.valueOf((int)this.SET_NUMBER)).CARDS, rarity));
                if (i >= this.CARDS - this.SHINY_CARDS) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74757_a("foil", true);
                    card2.func_77982_d(nbt);
                }
                cards.add((Object)card2);
            }
            if (this.SET_NUMBER == 7) {
                cards.add((Object)new ItemStack((IItemProvider)PackItem.getRandomGummyCard(BuddycardsItems.SETS.get((Object)Integer.valueOf((int)this.SET_NUMBER)).CARDS)));
            }
            cards.forEach(card -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)card));
            return ActionResult.func_226249_b_((Object)playerIn.func_184586_b(handIn));
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!ModList.get().isLoaded(this.SPECIFIC_MOD)) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public static CardItem getRandomCardOfRarity(ArrayList<RegistryObject<CardItem>> cards, Rarity rarity) {
        CardItem card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        while (card.getRarity() != rarity || card instanceof GummyCardItem) {
            card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        }
        return card;
    }

    public static CardItem getRandomGummyCard(ArrayList<RegistryObject<CardItem>> cards) {
        CardItem card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        while (!(card instanceof GummyCardItem)) {
            card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        }
        return card;
    }
}

