/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ConfigManager {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    public static ForgeConfigSpec.DoubleValue zombieChance;
    public static ForgeConfigSpec.DoubleValue villagerChance;
    public static ForgeConfigSpec.DoubleValue zombieVillagerChance;
    public static ForgeConfigSpec.DoubleValue piglinChance;
    public static ForgeConfigSpec.DoubleValue zombiePiglinChance;
    public static ForgeConfigSpec.DoubleValue shulkerChance;
    public static ForgeConfigSpec.DoubleValue enderlingChance;
    public static ForgeConfigSpec.DoubleValue dragonChance;
    public static ForgeConfigSpec.IntValue dragonMaxPacks;
    public static ForgeConfigSpec.DoubleValue witherChance;
    public static ForgeConfigSpec.IntValue witherMaxPacks;
    public static ForgeConfigSpec.BooleanValue doMedalEffects;
    public static ForgeConfigSpec.BooleanValue loadedMysteryCardsOnly;
    public static ForgeConfigSpec.DoubleValue enderlingChanceEnd;
    public static ForgeConfigSpec.DoubleValue enderlingChanceNether;
    public static ForgeConfigSpec.DoubleValue enderlingChanceOver;
    public static ForgeConfigSpec.IntValue luminisMaxY;
    public static ForgeConfigSpec.IntValue luminisPerChunk;
    public static ForgeConfigSpec.IntValue luminisVeinSize;
    public static ForgeConfigSpec.DoubleValue deepLuminisOdds;
    public static ForgeConfigSpec.DoubleValue cardLuminisOdds;
    public static ForgeConfigSpec.BooleanValue challengeMode;
    public static ForgeConfigSpec.IntValue challengePointsCommon;
    public static ForgeConfigSpec.IntValue challengePointsUncommon;
    public static ForgeConfigSpec.IntValue challengePointsRare;
    public static ForgeConfigSpec.IntValue challengePointsEpic;
    public static ForgeConfigSpec.DoubleValue challengeShinyMult;
    public static ForgeConfigSpec.DoubleValue challengeSet1Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet2Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet3Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet4Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet5Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet6Mult;
    public static ForgeConfigSpec.DoubleValue challengeSet7Mult;
    public static ForgeConfigSpec.DoubleValue challengeGrade1Mult;
    public static ForgeConfigSpec.DoubleValue challengeGrade2Mult;
    public static ForgeConfigSpec.DoubleValue challengeGrade3Mult;
    public static ForgeConfigSpec.DoubleValue challengeGrade4Mult;
    public static ForgeConfigSpec.DoubleValue challengeGrade5Mult;
    public static ForgeConfigSpec.DoubleValue aquacultureFishingChance;

    public static void loadConfig(String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    public static void init() {
        builder.comment("Buddycards config");
        zombieChance = builder.comment("\nOdds of baby zombie dropping base set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.zombieChance", 0.05, 0.0, 1.0);
        villagerChance = builder.comment("\nOdds of baby villager dropping base set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.villagerChance", 0.05, 0.0, 1.0);
        zombieVillagerChance = builder.comment("\nOdds of baby zombie villager dropping base set packs, 0 for 0%, 1 for 100%, default is 10%").defineInRange("mobDrops.zombieVillagerChance", 0.1, 0.0, 1.0);
        piglinChance = builder.comment("\nOdds of baby piglin dropping nether set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.piglinChance", 0.05, 0.0, 1.0);
        zombiePiglinChance = builder.comment("\nOdds of baby zombie piglin dropping nether set , 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.zombiePiglinChance", 0.05, 0.0, 1.0);
        shulkerChance = builder.comment("\nOdds of shulkers dropping end set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.shulkerChance", 0.05, 0.0, 1.0);
        enderlingChance = builder.comment("\nOdds of enderlings dropping end set packs, 0 for 0%, 1 for 100%, default is 10%").defineInRange("mobDrops.enderlingChance", 0.1, 0.0, 1.0);
        dragonChance = builder.comment("\nOdds of ender dragons dropping end set packs, 0 for 0%, 1 for 100%, default is 100%").defineInRange("mobDrops.dragonChance", 1.0, 0.0, 1.0);
        dragonMaxPacks = builder.comment("\nMaximum amount of packs dropped when a dragon drops packs, default is 4").defineInRange("mobDrops.dragonMaxPacks", 4, 1, 16);
        witherChance = builder.comment("\nOdds of withers dropping nether set packs, 0 for 0%, 1 for 100%, default is 50%").defineInRange("mobDrops.witherChance", 0.5, 0.0, 1.0);
        witherMaxPacks = builder.comment("\nMaximum amount of packs dropped when a wither drops packs, default is 3").defineInRange("mobDrops.witherMaxPacks", 3, 1, 16);
        enderlingChanceEnd = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the End, 0-1, default is 0.5%").defineInRange("enderling.endOdds", 0.005, 0.0, 1.0);
        enderlingChanceNether = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the Nether, 0-1, default is 0.5%").defineInRange("enderling.netherOdds", 0.005, 0.0, 1.0);
        enderlingChanceOver = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the Overworld, 0-1, default is 1.5%").defineInRange("enderling.overOdds", 0.015, 0.0, 1.0);
        luminisMaxY = builder.comment("\nMaximum Y value for Luminis to generate, 1-120, default is 24").defineInRange("luminis.maxY", 24, 1, 120);
        luminisPerChunk = builder.comment("\nAmount of veins of Luminis generated per chunk, 1-24, default is 1").defineInRange("luminis.perChunk", 1, 0, 36);
        luminisVeinSize = builder.comment("\nSize of Luminis veins, 1-36, default is 8").defineInRange("luminis.veinSize", 8, 1, 36);
        deepLuminisOdds = builder.comment("\nOdds of deep Luminis crystals being dropped by Luminis ore, note this can be doubled with certain gear, 0 for 0%, 1 for 100%, default is 3.5%").defineInRange("luminis.deepLuminisOdds", 0.035, 0.0, 1.0);
        cardLuminisOdds = builder.comment("\nOdds of a random shiny non-epic card being dropped by Luminis ore when using the Luminis Medal, 0 for 0%, 1 for 100%, default is 2%").defineInRange("luminis.cardLuminisOdds", 0.02, 0.0, 1.0);
        doMedalEffects = builder.comment("\nEnables medal effects, default is true").define("misc.doMedalEffects", true);
        loadedMysteryCardsOnly = builder.comment("\nMystery packs can be used to find any card in the mod, loaded or not, default is false").define("misc.boringMysteryPacks", false);
        aquacultureFishingChance = builder.comment("\nOdds of fishing up an Aquaculture set card or pack while using a buddycard hook, 0-1, default is .075").defineInRange("integration.aquacultureFishingChance", 0.05, 0.0, 1.0);
        challengeMode = builder.comment("\nEnable Challenge mode, assigning cards point values, and giving each player a challenge binder, default is false").define("challenge.doChallengeMode", false);
        challengePointsCommon = builder.comment("\nBase challenge points for common cards, 1-100, default is 1").defineInRange("challenge.pointsCommon", 1, 1, 100);
        challengePointsUncommon = builder.comment("\nBase challenge points for uncommon cards, 1-100, default is 2").defineInRange("challenge.pointsUncommon", 2, 1, 100);
        challengePointsRare = builder.comment("\nBase challenge points for rare cards, 1-100, default is 4").defineInRange("challenge.pointsRare", 4, 1, 100);
        challengePointsEpic = builder.comment("\nBase challenge points for epic cards, 1-100, default is 8").defineInRange("challenge.pointsEpic", 8, 1, 100);
        challengeShinyMult = builder.comment("\nMultiplier for challenge points on shiny cards, 0-10, default is 1.5").defineInRange("challenge.shinyMultiplier", 1.5, 0.0, 10.0);
        challengeSet1Mult = builder.comment("\nMultiplier for challenge points from base set, 0-10, default is 1").defineInRange("challenge.set1Multiplier", 1.0, 0.0, 10.0);
        challengeSet2Mult = builder.comment("\nMultiplier for challenge points from nether set, 0-10, default is 1.2").defineInRange("challenge.set2Multiplier", (double)1.2f, 0.0, 10.0);
        challengeSet3Mult = builder.comment("\nMultiplier for challenge points from end set, 0-10, default is 2").defineInRange("challenge.set3Multiplier", 2.0, 0.0, 10.0);
        challengeSet4Mult = builder.comment("\nMultiplier for challenge points from byg set, 0-10, default is 2").defineInRange("challenge.set4Multiplier", 2.0, 0.0, 10.0);
        challengeSet5Mult = builder.comment("\nMultiplier for challenge points from create set, 0-10, default is 1").defineInRange("challenge.set5Multiplier", 1.0, 0.0, 10.0);
        challengeSet6Mult = builder.comment("\nMultiplier for challenge points from aquaculture set, 0-10, default is 0.9").defineInRange("challenge.set6Multiplier", (double)0.9f, 0.0, 10.0);
        challengeSet7Mult = builder.comment("\nMultiplier for challenge points from fd set, 0-10, default is 1").defineInRange("challenge.set7Multiplier", 1.0, 0.0, 10.0);
        challengeGrade1Mult = builder.comment("\nMultiplier for challenge points with grade D, 0-10, default is 1").defineInRange("challenge.grade1Multiplier", 1.0, 0.0, 10.0);
        challengeGrade2Mult = builder.comment("\nMultiplier for challenge points with grade C, 0-10, default is 1.4").defineInRange("challenge.grade2Multiplier", (double)1.4f, 0.0, 10.0);
        challengeGrade3Mult = builder.comment("\nMultiplier for challenge points with grade B, 0-10, default is 1.8").defineInRange("challenge.grade3Multiplier", (double)1.8f, 0.0, 10.0);
        challengeGrade4Mult = builder.comment("\nMultiplier for challenge points with grade A, 0-10, default is 2.5").defineInRange("challenge.grade4Multiplier", 2.5, 0.0, 10.0);
        challengeGrade5Mult = builder.comment("\nMultiplier for challenge points with grade S, 0-10, default is 10").defineInRange("challenge.grade5Multiplier", 10.0, 0.0, 10.0);
    }

    static {
        ConfigManager.init();
        config = builder.build();
    }
}

