/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks;

import com.wildcard.buddycards.blocks.tiles.CardDisplayBlockEntity;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class CardDisplayBlock
extends BaseEntityBlock {
    public static final DirectionProperty DIR = BlockStateProperties.f_61374_;
    protected static final VoxelShape NSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ESHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    final String NEEDED_MOD;

    public CardDisplayBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIR, (Comparable)Direction.NORTH));
        this.NEEDED_MOD = "";
    }

    public CardDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIR, (Comparable)Direction.NORTH));
        this.NEEDED_MOD = "";
    }

    public CardDisplayBlock(String neededMod) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIR, (Comparable)Direction.NORTH));
        this.NEEDED_MOD = neededMod;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CardDisplayBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)DIR);
        switch (direction) {
            default: {
                return NSHAPE;
            }
            case EAST: {
                return ESHAPE;
            }
            case SOUTH: {
                return SSHAPE;
            }
            case WEST: 
        }
        return WSHAPE;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case CLOCKWISE_90: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                }
            }
            case CLOCKWISE_180: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIR, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIR});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int slot = this.getSlot((Direction)state.m_61143_((Property)DIR), hit.m_82450_());
        if (world.m_7702_(pos) instanceof CardDisplayBlockEntity) {
            CardDisplayBlockEntity displayTile = (CardDisplayBlockEntity)world.m_7702_(pos);
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == BuddycardsItems.BUDDYSTEEL_KEY.get()) {
                if (displayTile.isLocked()) {
                    if (displayTile.toggleLock(player.m_142081_())) {
                        player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_display.unlock"), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_display.fail_unlock"), true);
                    }
                } else {
                    displayTile.toggleLock(player.m_142081_());
                    player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_display.lock"), true);
                }
            } else if (displayTile.isLocked()) {
                player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_display.lock"), true);
            } else if (displayTile.getCardInSlot(slot).m_41720_() instanceof CardItem) {
                ItemStack oldCard = displayTile.getCardInSlot(slot);
                if (stack.m_41720_() instanceof CardItem) {
                    ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                    card.m_41751_(stack.m_41783_());
                    displayTile.putCardInSlot(card, slot);
                    stack.m_41774_(1);
                } else {
                    displayTile.putCardInSlot(ItemStack.f_41583_, slot);
                }
                player.m_36356_(oldCard);
            } else if (stack.m_41720_() instanceof CardItem) {
                ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                card.m_41751_(stack.m_41783_());
                displayTile.putCardInSlot(card, slot);
                stack.m_41774_(1);
            }
        }
        world.m_46717_(pos, (Block)this);
        return InteractionResult.SUCCESS;
    }

    private int getSlot(Direction dir, Vec3 hit) {
        hit = new Vec3((hit.f_82479_ < 0.0 ? hit.f_82479_ - Math.floor(hit.f_82479_) : hit.f_82479_) % 1.0, (hit.f_82480_ < 0.0 ? hit.f_82480_ - Math.floor(hit.f_82480_) : hit.f_82480_) % 1.0, (hit.f_82481_ < 0.0 ? hit.f_82481_ - Math.floor(hit.f_82481_) : hit.f_82481_) % 1.0);
        if (hit.f_82480_ > 0.5) {
            if (dir == Direction.NORTH) {
                if (hit.f_82479_ < 0.3333333432674408) {
                    return 1;
                }
                if (hit.f_82479_ < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.EAST) {
                if (hit.f_82481_ < 0.3333333432674408) {
                    return 1;
                }
                if (hit.f_82481_ < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.SOUTH) {
                if (hit.f_82479_ > 0.6666666865348816) {
                    return 1;
                }
                if (hit.f_82479_ > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.WEST) {
                if (hit.f_82481_ > 0.6666666865348816) {
                    return 1;
                }
                if (hit.f_82481_ > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
        } else {
            if (dir == Direction.NORTH) {
                if (hit.f_82479_ < 0.3333333432674408) {
                    return 4;
                }
                if (hit.f_82479_ < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.EAST) {
                if (hit.f_82481_ < 0.3333333432674408) {
                    return 4;
                }
                if (hit.f_82481_ < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.SOUTH) {
                if (hit.f_82479_ > 0.6666666865348816) {
                    return 4;
                }
                if (hit.f_82479_ > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.WEST) {
                if (hit.f_82481_ > 0.6666666865348816) {
                    return 4;
                }
                if (hit.f_82481_ > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
        }
        return 1;
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (world.m_7702_(pos) instanceof CardDisplayBlockEntity) {
            Containers.m_19010_((Level)world, (BlockPos)pos, ((CardDisplayBlockEntity)world.m_7702_(pos)).getInventory());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.NEEDED_MOD != "" && !ModList.get().isLoaded(this.NEEDED_MOD)) {
            return;
        }
        super.m_49811_(group, items);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        CardDisplayBlockEntity displayTile = (CardDisplayBlockEntity)world.m_7702_(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        CardDisplayBlockEntity displayTile = (CardDisplayBlockEntity)world.m_7702_(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof CardDisplayBlockEntity) {
            return ((CardDisplayBlockEntity)tileentity).getCardsAmt();
        }
        return 0;
    }
}

