/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks;

import com.wildcard.buddycards.blocks.tiles.CardStandBlockEntity;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class CardStandBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    final String NEEDED_MOD;

    public CardStandBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_));
        this.NEEDED_MOD = "";
    }

    public CardStandBlock(String neededMod) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_));
        this.NEEDED_MOD = neededMod;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CardStandBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_7702_(pos) instanceof CardStandBlockEntity) {
            CardStandBlockEntity standTile = (CardStandBlockEntity)world.m_7702_(pos);
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == BuddycardsItems.BUDDYSTEEL_KEY.get()) {
                if (standTile.isLocked()) {
                    if (standTile.toggleLock(player.m_142081_())) {
                        player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_stand.unlock"), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_stand.fail_unlock"), true);
                    }
                } else {
                    standTile.toggleLock(player.m_142081_());
                    player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_stand.lock"), true);
                }
            } else if (standTile.isLocked()) {
                player.m_5661_((Component)new TranslatableComponent("block.buddycards.card_stand.lock"), true);
            } else if (standTile.getCard().m_41720_() instanceof CardItem) {
                ItemStack oldCard = standTile.getCard();
                if (stack.m_41720_() instanceof CardItem) {
                    ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                    card.m_41751_(stack.m_41783_());
                    standTile.setCard(card);
                    stack.m_41774_(1);
                } else {
                    standTile.setCard(ItemStack.f_41583_);
                }
                player.m_36356_(oldCard);
                standTile.setDir((int)((double)(player.m_6080_() * 16.0f / 360.0f) + 0.5) & 0xF);
            } else if (stack.m_41720_() instanceof CardItem) {
                ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                card.m_41751_(stack.m_41783_());
                standTile.setCard(card);
                stack.m_41774_(1);
                standTile.setDir((int)((double)(player.m_6080_() * 16.0f / 360.0f) + 0.5) & 0xF);
            }
        }
        world.m_46717_(pos, (Block)this);
        return InteractionResult.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (world.m_7702_(pos) instanceof CardStandBlockEntity) {
            Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)NonNullList.m_122780_((int)1, (Object)((CardStandBlockEntity)world.m_7702_(pos)).getCard()));
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.NEEDED_MOD != "" && !ModList.get().isLoaded(this.NEEDED_MOD)) {
            return;
        }
        super.m_49811_(group, items);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        CardStandBlockEntity displayTile = (CardStandBlockEntity)world.m_7702_(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        CardStandBlockEntity displayTile = (CardStandBlockEntity)world.m_7702_(pos);
        if (displayTile.isLocked()) {
            return false;
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof CardStandBlockEntity && ((CardStandBlockEntity)tileentity).getCard().m_41619_()) {
            return 10;
        }
        return 0;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return CardStandBlock.m_49936_((BlockGetter)worldIn, (BlockPos)blockpos) || CardStandBlock.m_49863_((LevelReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public boolean m_5568_() {
        return true;
    }
}

