/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks.tiles;

import com.wildcard.buddycards.container.VaultContainer;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BuddysteelVaultBlockEntity
extends BlockEntity
implements MenuProvider {
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(120){

        public boolean isItemValid(int slot, ItemStack stack) {
            return !BuddysteelVaultBlockEntity.this.locked && (slot >= 108 || stack.m_41720_() instanceof CardItem) && super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (BuddysteelVaultBlockEntity.this.locked) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    });
    private Component name;
    private boolean locked = false;
    private String player = "";

    public BuddysteelVaultBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuddycardsEntities.VAULT_TILE.get(), pos, state);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new VaultContainer(id, inventory, this.m_58899_());
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean toggleLock(UUID playerUUID) {
        if (this.locked) {
            if (!this.player.equals(playerUUID.toString())) return false;
            this.locked = false;
        } else {
            this.player = playerUUID.toString();
            this.locked = true;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        tag.m_128379_("locked", this.locked);
        tag.m_128359_("player", this.player);
        if (this.name != null) {
            tag.m_128359_("name", Component.Serializer.m_130703_((Component)this.name));
        }
        this.handler.ifPresent(stack -> {
            CompoundTag compound = (CompoundTag)stack.serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        return super.m_6945_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.locked = tag.m_128471_("locked");
        this.player = tag.m_128461_("player");
        if (tag.m_128441_("name")) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("name"));
        }
        CompoundTag invTag = tag.m_128469_("inv");
        this.handler.ifPresent(stack -> stack.deserializeNBT((Tag)invTag));
    }

    public Component m_5446_() {
        if (this.name != null) {
            return this.name;
        }
        return new TranslatableComponent("block.buddycards.buddysteel_vault");
    }

    public void setDisplayName(Component nameIn) {
        this.name = nameIn;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandler getHandler() {
        return (IItemHandler)this.handler.orElse((Object)new ItemStackHandler(120));
    }
}

