/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks.tiles;

import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CardDisplayBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private boolean locked = false;
    private String player = "";

    public CardDisplayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuddycardsEntities.CARD_DISPLAY_TILE.get(), pos, state);
    }

    public void putCardInSlot(ItemStack stack, int pos) {
        if (this.f_58857_ != null) {
            this.inventory.set(pos - 1, (Object)stack);
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ItemStack getCardInSlot(int pos) {
        return (ItemStack)this.inventory.get(pos - 1);
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean toggleLock(UUID playerUUID) {
        if (this.locked) {
            if (!this.player.equals(playerUUID.toString())) return false;
            this.locked = false;
        } else {
            this.player = playerUUID.toString();
            this.locked = true;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        ContainerHelper.m_18976_((CompoundTag)compound, this.inventory, (boolean)true);
        compound.m_128379_("locked", this.locked);
        compound.m_128359_("player", this.player);
        return compound;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.locked = nbt.m_128471_("locked");
        this.player = nbt.m_128461_("player");
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getCardsAmt() {
        int amt = 0;
        for (int i = 0; i < 6; ++i) {
            if (!(((ItemStack)this.inventory.get(i)).m_41720_() instanceof CardItem)) continue;
            ++amt;
        }
        return amt;
    }

    public void m_6211_() {
        this.inventory.clear();
    }
}

