/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CardModelGen
extends ItemModelProvider {
    public CardModelGen(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        int j;
        int i;
        for (i = 1; i <= 5; ++i) {
            for (j = 1; j <= 27; ++j) {
                this.genCardModels(i, j);
            }
        }
        for (i = 6; i <= 7; ++i) {
            for (j = 1; j <= 18; ++j) {
                this.genCardModels(i, j);
            }
        }
        for (i = 1; i <= 6; ++i) {
            this.genGummyCardModels(i);
        }
        for (i = 1; i <= 3; ++i) {
            this.genCardModels(8, i);
        }
    }

    void genCardModels(int setNum, int cardNum) {
        if (setNum > 0) {
            ResourceLocation location1 = new ResourceLocation("buddycards", "item/card." + setNum + "." + cardNum);
            ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(location1)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/card")))).texture("layer0", new ResourceLocation("buddycards", this.getSetFolder(setNum) + cardNum));
            card.override().predicate(new ResourceLocation("grade"), 1.0f).model(this.genGradedCardModel(setNum, cardNum, 1));
            card.override().predicate(new ResourceLocation("grade"), 2.0f).model(this.genGradedCardModel(setNum, cardNum, 2));
            card.override().predicate(new ResourceLocation("grade"), 3.0f).model(this.genGradedCardModel(setNum, cardNum, 3));
            card.override().predicate(new ResourceLocation("grade"), 4.0f).model(this.genGradedCardModel(setNum, cardNum, 4));
            card.override().predicate(new ResourceLocation("grade"), 5.0f).model(this.genGradedCardModel(setNum, cardNum, 5));
            this.generatedModels.put(location1, card);
        }
    }

    String getSetFolder(int set) {
        switch (set) {
            case 1: {
                return "items/base_set/";
            }
            case 2: {
                return "items/nether_set/";
            }
            case 3: {
                return "items/end_set/";
            }
            case 4: {
                return "items/byg_set/";
            }
            case 5: {
                return "items/create_set/";
            }
            case 6: {
                return "items/aquaculture_set/";
            }
            case 7: {
                return "items/fd_set/";
            }
            case 8: {
                return "items/promo_set/";
            }
        }
        return "error";
    }

    ModelFile genGradedCardModel(int setNum, int cardNum, int grade) {
        ResourceLocation location = new ResourceLocation("buddycards", "item/card." + setNum + "." + cardNum + "g" + grade);
        ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(location)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/card")))).texture("layer0", new ResourceLocation("buddycards", this.getSetFolder(setNum) + cardNum));
        this.generatedModels.put(location, (ItemModelBuilder)card.texture("layer1", new ResourceLocation("buddycards", "items/grade/" + grade)));
        return card;
    }

    void genGummyCardModels(int cardNum) {
        ResourceLocation location = new ResourceLocation("buddycards", "item/card.7.gummy" + cardNum);
        ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(location)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/card")))).texture("layer0", new ResourceLocation("buddycards", "items/fd_set/gummy" + cardNum));
        this.generatedModels.put(location, card);
    }
}

