/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.entities;

import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.util.EnderlingOfferMaker;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class EnderlingEntity
extends PathfinderMob
implements Npc,
Merchant,
Nameable {
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BuddycardsItems.MYSTERY_PACK.get(), (ItemLike)BuddycardsItems.END_SET.PACK.get(), (ItemLike)BuddycardsItems.ZYLEX.get()});
    private Player customer;
    private MerchantOffers offers;
    private int resets;

    public EnderlingEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.0f;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder setupAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 0.75, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5, 0.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, (double)0.6f, 1.5f, 6.0f));
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(3);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11849_;
    }

    protected void m_8024_() {
        float f;
        if (this.f_19853_.m_46461_() && this.f_19797_ >= 600 && (f = this.m_6073_()) > 0.5f && this.f_19853_.m_45527_(this.m_142538_()) && this.f_19796_.nextFloat() * 60.0f < (f - 0.4f) * 2.0f) {
            this.teleport();
        }
        super.m_8024_();
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.nextInt(32) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        if (blockstate.m_60767_().m_76334_() && !blockstate.m_60819_().m_76153_((Tag)FluidTags.f_13131_)) {
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)this, p_70825_1_, p_70825_3_, p_70825_5_);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean success = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (success && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return success;
        }
        return false;
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    public void m_7189_(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.customer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeDate();
        }
        if (this.offers.size() == 7 && this.resets >= 2 && this.resets % 2 == 0) {
            boolean flag = true;
            for (int i = 0; i < 7 && flag; ++i) {
                if (((MerchantOffer)this.offers.get(i)).m_45380_()) continue;
                flag = false;
            }
            if (flag) {
                this.offers.add((Object)EnderlingOfferMaker.createSpecialtyOffer(this.m_21187_()));
            }
        }
        return this.offers;
    }

    private void populateTradeDate() {
        this.offers.add((Object)EnderlingOfferMaker.createCardBuyOffer());
        this.offers.add((Object)EnderlingOfferMaker.createGradedCardBuyOffer());
        this.offers.add((Object)EnderlingOfferMaker.createGenericOffer());
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (this.offers.size() < 7) {
            if (this.offers.size() == 3) {
                this.offers.add((Object)EnderlingOfferMaker.createGradedCardSellOffer());
            } else if (this.offers.size() == 4) {
                this.offers.add((Object)EnderlingOfferMaker.createPackOffer());
            } else {
                this.offers.add((Object)EnderlingOfferMaker.createGenericOffer());
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compound.m_128469_("Offers"));
        }
        this.resets = compound.m_128451_("Resets");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.offers != null) {
            compound.m_128365_("Offers", (net.minecraft.nbt.Tag)this.offers.m_45388_());
        }
        compound.m_128405_("Resets", this.resets);
    }

    public void m_7713_(ItemStack stack) {
    }

    public Level m_7133_() {
        return this.f_19853_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_11899_;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.offers != null && !this.f_19853_.f_46443_ && (heldItem.m_41720_() == BuddycardsItems.ZYLEX_TOKEN.get() || ModList.get().isLoaded("curios") && (CuriosApi.getCuriosHelper().findEquippedCurio((Item)BuddycardsItems.ZYLEX_MEDAL.get(), (LivingEntity)player).isPresent() && ((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)BuddycardsItems.ZYLEX_MEDAL.get()), (LivingEntity)player).get()).right).m_41720_().equals(BuddycardsItems.ZYLEX_MEDAL.get()) || CuriosApi.getCuriosHelper().findEquippedCurio((Item)BuddycardsItems.PERFECT_BUDDYSTEEL_MEDAL.get(), (LivingEntity)player).isPresent() && ((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)BuddycardsItems.PERFECT_BUDDYSTEEL_MEDAL.get()), (LivingEntity)player).get()).right).m_41720_().equals(BuddycardsItems.PERFECT_BUDDYSTEEL_MEDAL.get())))) {
            boolean flag = true;
            for (int i = 0; i < this.offers.size() && flag; ++i) {
                if (((MerchantOffer)this.offers.get(i)).m_45380_()) continue;
                flag = false;
            }
            if (flag) {
                this.offers.clear();
                this.populateTradeDate();
                ++this.resets;
                if (heldItem.m_41720_() == BuddycardsItems.ZYLEX_TOKEN.get()) {
                    heldItem.m_41774_(1);
                }
            }
        }
        if (heldItem.m_41720_() == Items.f_42656_) {
            heldItem.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6084_() && this.customer == null && !this.f_19853_.f_46443_) {
            this.m_6616_();
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static class TradeWithPlayerGoal
    extends Goal {
        private final EnderlingEntity enderling;

        public TradeWithPlayerGoal(EnderlingEntity enderling) {
            this.enderling = enderling;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.enderling.m_6084_()) {
                return false;
            }
            if (this.enderling.m_20069_()) {
                return false;
            }
            if (!this.enderling.m_20096_()) {
                return false;
            }
            if (this.enderling.f_19864_) {
                return false;
            }
            Player playerentity = this.enderling.m_7962_();
            if (playerentity == null) {
                return false;
            }
            if (this.enderling.m_20280_((Entity)playerentity) > 16.0) {
                return false;
            }
            return playerentity.f_36096_ != null;
        }

        public void m_8056_() {
            this.enderling.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.enderling.m_7189_(null);
        }
    }
}

