/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.items;

import com.wildcard.buddycards.BuddyCards;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import com.wildcard.buddycards.util.ConfigManager;
import java.util.Calendar;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class CardItem
extends Item {
    public final int SET_NUMBER;
    public final int CARD_NUMBER;
    private final Rarity RARITY;
    private final String MOD_ID;

    public CardItem(int setNumber, int cardNumber, Rarity rarity, String modId) {
        super(new Item.Properties().m_41491_(BuddyCards.CARDS_TAB));
        this.SET_NUMBER = setNumber;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.MOD_ID = modId;
    }

    public CardItem(int setNumber, int cardNumber, Rarity rarity, String modId, Item.Properties properties) {
        super(properties);
        this.SET_NUMBER = setNumber;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.MOD_ID = modId;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.buddycards.card." + this.SET_NUMBER + "." + this.CARD_NUMBER + ".tooltip"));
        if (this.SET_NUMBER == 8) {
            TranslatableComponent cn = new TranslatableComponent("item.buddycards.promo." + this.CARD_NUMBER);
            if (this.m_5812_(stack)) {
                cn.m_7220_((Component)new TranslatableComponent("item.buddycards.shiny_symbol"));
            }
            tooltip.add((Component)cn);
        } else {
            TranslatableComponent cn = new TranslatableComponent("item.buddycards.number_separator");
            cn.m_130946_("" + this.CARD_NUMBER);
            if (this.m_5812_(stack)) {
                cn.m_7220_((Component)new TranslatableComponent("item.buddycards.shiny_symbol"));
            }
            tooltip.add((Component)new TranslatableComponent("item.buddycards.set." + this.SET_NUMBER).m_7220_((Component)cn));
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128451_("grade") != 0) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.grade_info").m_7220_((Component)new TranslatableComponent("item.buddycards.grade_" + stack.m_41783_().m_128451_("grade"))));
        }
        if (((Boolean)ConfigManager.challengeMode.get()).booleanValue()) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.points_info").m_130946_("" + ((CardItem)stack.m_41720_()).getPointValue(stack)));
        }
        if (stack.m_41720_().getRegistryName().toString().endsWith("s")) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.foil_warning"));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("foil") && stack.m_41783_().m_128471_("foil");
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.RARITY;
    }

    public Rarity getRarity() {
        return this.RARITY;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            boolean doFill = false;
            if (this.SET_NUMBER == 8) {
                Calendar calendar = Calendar.getInstance();
                if (this.CARD_NUMBER <= 3 && calendar.get(2) == 9 && calendar.get(5) >= 30) {
                    doFill = true;
                }
            } else if (ModList.get().isLoaded(this.MOD_ID)) {
                doFill = true;
            }
            if (doFill) {
                ItemStack foil = new ItemStack((ItemLike)this);
                CompoundTag nbt = new CompoundTag();
                nbt.m_128379_("foil", true);
                foil.m_41751_(nbt);
                items.add((Object)new ItemStack((ItemLike)this));
                items.add((Object)foil);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            return this.tryGrade((Item)BuddycardsItems.GRADING_SLEEVE.get(), worldIn, playerIn, handIn);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public InteractionResultHolder<ItemStack> tryGrade(Item gradingSleeve, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_21120_(InteractionHand.OFF_HAND).m_41720_().equals(gradingSleeve)) {
            CompoundTag nbt = playerIn.m_21120_(handIn).m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if (nbt.m_128451_("grade") == 0) {
                playerIn.m_21120_(InteractionHand.OFF_HAND).m_41774_(1);
                int i = (int)(Math.random() * 500.0) + 1;
                int k = 0;
                if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosHelper().findEquippedCurio((Item)BuddycardsItems.ZYLEX_RING.get(), (LivingEntity)playerIn).isPresent() && ((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)BuddycardsItems.ZYLEX_RING.get()), (LivingEntity)playerIn).get()).right).m_41720_().equals(BuddycardsItems.ZYLEX_RING.get())) {
                    ++k;
                }
                if (playerIn.m_21023_((MobEffect)BuddycardsMisc.GRADING_LUCK.get())) {
                    k += playerIn.m_21124_((MobEffect)BuddycardsMisc.GRADING_LUCK.get()).m_19564_();
                }
                if (k > 0) {
                    for (int j = 0; j <= k && i < 400; ++j) {
                        i = (int)(Math.random() * 500.0) + 1;
                    }
                }
                int grade = i < 200 ? 1 : (i < 360 ? 2 : (i < 450 ? 3 : (i < 500 ? 4 : 5)));
                nbt.m_128405_("grade", grade);
                ItemStack card = new ItemStack((ItemLike)playerIn.m_21120_(handIn).m_41720_(), 1);
                card.m_41751_(nbt);
                playerIn.m_21120_(handIn).m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)card);
                return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public int getPointValue(ItemStack card) {
        double points = 0.0;
        points = card.m_41791_() == Rarity.COMMON ? (double)((Integer)ConfigManager.challengePointsCommon.get()).intValue() : (card.m_41791_() == Rarity.UNCOMMON ? (double)((Integer)ConfigManager.challengePointsUncommon.get()).intValue() : (card.m_41791_() == Rarity.RARE ? (double)((Integer)ConfigManager.challengePointsRare.get()).intValue() : (double)((Integer)ConfigManager.challengePointsEpic.get()).intValue()));
        if (this.SET_NUMBER == 1) {
            points *= ((Double)ConfigManager.challengeSet1Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 2) {
            points *= ((Double)ConfigManager.challengeSet2Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 3) {
            points *= ((Double)ConfigManager.challengeSet3Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 4) {
            points *= ((Double)ConfigManager.challengeSet4Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 5) {
            points *= ((Double)ConfigManager.challengeSet5Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 6) {
            points *= ((Double)ConfigManager.challengeSet6Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 7) {
            points *= ((Double)ConfigManager.challengeSet7Mult.get()).doubleValue();
        }
        if (card.m_41783_() != null) {
            int grade = card.m_41783_().m_128451_("grade");
            if (grade == 1) {
                points *= ((Double)ConfigManager.challengeGrade1Mult.get()).doubleValue();
            } else if (grade == 2) {
                points *= ((Double)ConfigManager.challengeGrade2Mult.get()).doubleValue();
            } else if (grade == 3) {
                points *= ((Double)ConfigManager.challengeGrade3Mult.get()).doubleValue();
            } else if (grade == 4) {
                points *= ((Double)ConfigManager.challengeGrade4Mult.get()).doubleValue();
            } else if (grade == 5) {
                points *= ((Double)ConfigManager.challengeGrade5Mult.get()).doubleValue();
            }
        }
        if (card.m_41790_()) {
            points *= ((Double)ConfigManager.challengeShinyMult.get()).doubleValue();
        }
        return (int)(points + 0.5);
    }
}

