/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.items;

import com.wildcard.buddycards.BuddyCards;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.items.GummyCardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.util.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.items.ItemHandlerHelper;

public class PackItem
extends Item {
    final int SET_NUMBER;
    final String SPECIFIC_MOD;
    final int CARDS;
    final int SHINY_CARDS;

    public PackItem(int setNumber, String modId, int cards, int shinyCards) {
        super(new Item.Properties().m_41491_(BuddyCards.TAB).m_41487_(16));
        this.SET_NUMBER = setNumber;
        this.SPECIFIC_MOD = modId;
        this.CARDS = cards;
        this.SHINY_CARDS = shinyCards;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.buddycards.set." + this.SET_NUMBER));
        tooltip.add((Component)new TranslatableComponent("item.buddycards.contains." + this.SET_NUMBER));
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.SET_NUMBER != 0 ? Rarity.UNCOMMON : Rarity.RARE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn instanceof ServerLevel) {
            playerIn.m_21120_(handIn).m_41774_(1);
            NonNullList cards = NonNullList.m_122779_();
            for (int i = 0; i < this.CARDS; ++i) {
                float rand = worldIn.f_46441_.nextFloat();
                Rarity rarity = (double)rand < 0.5 ? Rarity.COMMON : ((double)rand < 0.8 ? Rarity.UNCOMMON : ((double)rand < 0.95 ? Rarity.RARE : Rarity.EPIC));
                ItemStack card2 = this.SET_NUMBER == 0 ? (((Boolean)ConfigManager.loadedMysteryCardsOnly.get()).booleanValue() ? new ItemStack((ItemLike)PackItem.getRandomCardOfRarity(BuddycardsItems.LOADED_CARDS, rarity)) : new ItemStack((ItemLike)PackItem.getRandomCardOfRarity(BuddycardsItems.ALL_CARDS, rarity))) : new ItemStack((ItemLike)PackItem.getRandomCardOfRarity(BuddycardsItems.SETS.get((Object)Integer.valueOf((int)this.SET_NUMBER)).CARDS, rarity));
                if (i >= this.CARDS - this.SHINY_CARDS) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128379_("foil", true);
                    card2.m_41751_(nbt);
                }
                cards.add((Object)card2);
            }
            if (this.SET_NUMBER == 7) {
                cards.add((Object)new ItemStack((ItemLike)PackItem.getRandomGummyCard(BuddycardsItems.SETS.get((Object)Integer.valueOf((int)this.SET_NUMBER)).CARDS)));
            }
            cards.forEach(card -> ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)card));
            return InteractionResultHolder.m_19096_((Object)playerIn.m_21120_(handIn));
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!ModList.get().isLoaded(this.SPECIFIC_MOD)) {
            return;
        }
        super.m_6787_(group, items);
    }

    public static CardItem getRandomCardOfRarity(ArrayList<RegistryObject<CardItem>> cards, Rarity rarity) {
        CardItem card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        while (card.getRarity() != rarity || card instanceof GummyCardItem || card.getRegistryName().toString().endsWith("s")) {
            card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        }
        return card;
    }

    public static CardItem getRandomGummyCard(ArrayList<RegistryObject<CardItem>> cards) {
        CardItem card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        while (!(card instanceof GummyCardItem)) {
            card = (CardItem)cards.get((int)(Math.random() * (double)cards.size())).get();
        }
        return card;
    }
}

