/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.google.common.collect.Lists;
import com.wildcard.buddycards.blocks.CardDisplayBlock;
import com.wildcard.buddycards.blocks.CardStandBlock;
import com.wildcard.buddycards.blocks.tiles.CardDisplayBlockEntity;
import com.wildcard.buddycards.blocks.tiles.CardStandBlockEntity;
import com.wildcard.buddycards.registries.BuddycardsBlocks;
import com.wildcard.buddycards.registries.BuddycardsItems;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockExplodeHandler {
    @SubscribeEvent
    public void explosionModify(ExplosionEvent.Detonate event) {
        ArrayList replacedExplosion = Lists.newArrayList();
        int deepLuminisBlocks = 0;
        int lapisBlocks = 0;
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            BlockEntity tile;
            BlockState targetBlock = event.getWorld().m_8055_((BlockPos)event.getAffectedBlocks().get(i));
            if (targetBlock.m_60734_() instanceof CardDisplayBlock) {
                tile = (CardDisplayBlockEntity)event.getWorld().m_7702_((BlockPos)event.getAffectedBlocks().get(i));
                if (tile.isLocked()) continue;
                replacedExplosion.add((BlockPos)event.getAffectedBlocks().get(i));
                continue;
            }
            if (targetBlock.m_60734_() instanceof CardStandBlock) {
                tile = (CardStandBlockEntity)event.getWorld().m_7702_((BlockPos)event.getAffectedBlocks().get(i));
                if (tile.isLocked()) continue;
                replacedExplosion.add((BlockPos)event.getAffectedBlocks().get(i));
                continue;
            }
            if (targetBlock.m_60734_().equals(BuddycardsBlocks.DEEP_LUMINIS_BLOCK.get())) {
                ++deepLuminisBlocks;
                replacedExplosion.add((BlockPos)event.getAffectedBlocks().get(i));
                continue;
            }
            if (targetBlock.m_60734_().equals(Blocks.f_50060_)) {
                ++lapisBlocks;
                replacedExplosion.add((BlockPos)event.getAffectedBlocks().get(i));
                continue;
            }
            replacedExplosion.add((BlockPos)event.getAffectedBlocks().get(i));
        }
        event.getExplosion().m_46080_();
        event.getAffectedBlocks().addAll(replacedExplosion);
        if (Math.random() * 2.0 < (double)deepLuminisBlocks) {
            Containers.m_18992_((Level)event.getWorld(), (double)event.getExplosion().getPosition().f_82479_, (double)event.getExplosion().getPosition().f_82480_, (double)event.getExplosion().getPosition().f_82481_, (ItemStack)BlockExplodeHandler.createLuminisDrop(event.getWorld().m_5822_(), deepLuminisBlocks, lapisBlocks));
        }
    }

    public static ItemStack createLuminisDrop(Random random, int luminisIn, int lapisIn) {
        double rand = Math.random() + 0.05 * (double)luminisIn;
        if (rand > 0.9) {
            ItemStack medal = new ItemStack((ItemLike)BuddycardsItems.LUMINIS_MEDAL.get());
            if ((int)rand != 0) {
                EnchantmentHelper.m_44877_((Random)random, (ItemStack)medal, (int)(15 * lapisIn), (boolean)true);
            }
            return medal;
        }
        if (rand > 0.8) {
            ItemStack pick = new ItemStack((ItemLike)BuddycardsItems.LUMINIS_HELMET.get());
            if ((int)rand != 0) {
                EnchantmentHelper.m_44877_((Random)random, (ItemStack)pick, (int)(15 * lapisIn), (boolean)true);
            }
            return pick;
        }
        if (rand > 0.7) {
            ItemStack pick = new ItemStack((ItemLike)BuddycardsItems.LUMINIS_PICKAXE.get());
            if ((int)rand != 0) {
                EnchantmentHelper.m_44877_((Random)random, (ItemStack)pick, (int)(15 * lapisIn), (boolean)true);
            }
            return pick;
        }
        if (rand > 0.3) {
            return new ItemStack((ItemLike)BuddycardsItems.LUMINIS_RING.get(), 1);
        }
        return new ItemStack((ItemLike)BuddycardsItems.LUMINIS.get(), (int)(rand * 64.0));
    }
}

