/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.integration.aquaculture.BuddysteelFishingRodItem;
import com.wildcard.buddycards.items.BinderItem;
import com.wildcard.buddycards.items.MedalItem;
import com.wildcard.buddycards.items.YannelArmorItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelArmorItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelAxeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelHoeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelPickaxeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelShovelItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelSwordItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class BuddyEnchantmentHandler {
    private Map<String, NonNullList<ItemStack>> items = new HashMap<String, NonNullList<ItemStack>>();
    public static final EnchantmentCategory BUDDY_BINDABLE = EnchantmentCategory.create((String)"BUDDY_BINDABLE", BuddyEnchantmentHandler::canBuddyBind);
    public static final EnchantmentCategory BUDDY_MEDAL = EnchantmentCategory.create((String)"BUDDY_MEDAL", i -> i instanceof MedalItem);
    public static final EnchantmentCategory BUDDY_BINDER = EnchantmentCategory.create((String)"BUDDY_BINDER", i -> i instanceof BinderItem);
    public static final EnchantmentCategory BUDDY_ARMOR = EnchantmentCategory.create((String)"BUDDY_ARMOR", i -> i instanceof BuddysteelArmorItem);
    public static final EnchantmentCategory BUDDY_TOOLS = EnchantmentCategory.create((String)"BUDDY_TOOLS", i -> i instanceof BuddysteelAxeItem || i instanceof BuddysteelHoeItem || i instanceof BuddysteelPickaxeItem || i instanceof BuddysteelShovelItem);
    public static final EnchantmentCategory BUDDY_WEAPONS = EnchantmentCategory.create((String)"BUDDY_WEAPONS", i -> i instanceof BuddysteelAxeItem || i instanceof BuddysteelSwordItem);
    public static final EnchantmentCategory YANNEL_ARMOR = EnchantmentCategory.create((String)"YANNEL_ARMOR", i -> i instanceof YannelArmorItem || i instanceof ElytraItem);

    @SubscribeEvent
    public void drop(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            boolean empty = true;
            NonNullList itemsToSave = NonNullList.m_122779_();
            for (ItemEntity i : event.getDrops()) {
                double rand = Math.random();
                switch (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BuddycardsMisc.BUDDY_BINDING.get()), (ItemStack)i.m_32055_())) {
                    case 1: {
                        if (rand < 0.3) break;
                    }
                    case 2: {
                        if (rand < 0.2) break;
                    }
                    case 3: {
                        itemsToSave.add((Object)i.m_32055_());
                        empty = false;
                    }
                }
            }
            if (!empty) {
                this.items.put(player.m_142081_().toString(), (NonNullList<ItemStack>)itemsToSave);
            }
            if (this.items.containsKey(player.m_142081_().toString())) {
                List list = this.items.get(player.m_142081_().toString()).subList(0, this.items.get(player.m_142081_().toString()).size());
                Stream stream = StreamSupport.stream(event.getDrops().spliterator(), false);
                Set remove = stream.filter(itemToFilter -> list.contains(itemToFilter.m_32055_())).collect(Collectors.toSet());
                event.getDrops().removeAll(remove);
            }
        }
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.Clone event) {
        Player player = event.getPlayer();
        if (event.isWasDeath() && this.items.containsKey(player.m_142081_().toString())) {
            for (ItemStack i : this.items.get(player.m_142081_().toString())) {
                player.m_36356_(i);
            }
            this.items.remove(player.m_142081_().toString());
        }
    }

    public static boolean canBuddyBind(Item item) {
        if (item instanceof BinderItem || item instanceof MedalItem || item instanceof BuddysteelArmorItem || item instanceof BuddysteelAxeItem || item instanceof BuddysteelHoeItem || item instanceof BuddysteelPickaxeItem || item instanceof BuddysteelShovelItem || item instanceof BuddysteelPickaxeItem) {
            return true;
        }
        if (ModList.get().isLoaded("aquaculture") && item instanceof BuddysteelFishingRodItem) {
            return true;
        }
        return item.equals(BuddycardsItems.ZYLEX_RING.get()) || item.equals(BuddycardsItems.LUMINIS_RING.get());
    }
}

