/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import com.wildcard.buddycards.util.BuddyEnchantmentHandler;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fmllegacy.RegistryObject;

public class BuddysteelGearHelper {
    public static void addInformation(ItemStack stack, List<Component> tooltip) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("Enchantments")) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.buddysteel_gear.desc"));
        }
    }

    public static boolean setTag(Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            boolean altered = false;
            float ratio = BuddysteelGearHelper.getRatio((ServerPlayer)playerIn);
            ItemStack stack = playerIn.m_21120_(handIn);
            if (BuddyEnchantmentHandler.BUDDY_TOOLS.m_7454_(stack.m_41720_()) && BuddysteelGearHelper.setEnchant((int)(ratio * 4.0f), stack, (Enchantment)BuddycardsMisc.BUDDY_EFF.get(), playerIn)) {
                altered = true;
            }
            if (BuddyEnchantmentHandler.BUDDY_ARMOR.m_7454_(stack.m_41720_()) && BuddysteelGearHelper.setEnchant((int)(ratio * 4.0f), stack, (Enchantment)BuddycardsMisc.BUDDY_PROT.get(), playerIn)) {
                altered = true;
            }
            if (BuddyEnchantmentHandler.BUDDY_WEAPONS.m_7454_(stack.m_41720_()) && BuddysteelGearHelper.setEnchant((int)(ratio * 4.0f), stack, (Enchantment)BuddycardsMisc.BUDDY_DMG.get(), playerIn)) {
                altered = true;
            }
            if (BuddyEnchantmentHandler.BUDDY_MEDAL.m_7454_(stack.m_41720_()) && BuddysteelGearHelper.setEnchant((int)(ratio * 5.0f), stack, (Enchantment)BuddycardsMisc.BUDDY_BOOST.get(), playerIn)) {
                altered = true;
            }
            return altered;
        }
        return false;
    }

    public static float getRatio(ServerPlayer player) {
        int i = 0;
        int total = 0;
        for (RegistryObject<CardItem> card : BuddycardsItems.LOADED_CARDS) {
            if (player.m_8951_().m_13015_(Stats.f_12984_.m_12902_((Object)((Item)card.get()))) > 0) {
                ++i;
            }
            ++total;
        }
        System.out.println("Player " + player.m_7755_() + " is getting a Buddysteel buff, current power level is " + (float)i / (float)total);
        return (float)i / (float)total;
    }

    public static boolean setEnchant(int level, ItemStack stack, Enchantment enchantment, Player player) {
        int initialLevel = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
        if (level == initialLevel) {
            if (level == 0) {
                player.m_5661_((Component)new TranslatableComponent("item.buddycards.buddysteel_gear.low"), true);
            }
            return false;
        }
        if (initialLevel != 0) {
            player.m_5661_((Component)new TranslatableComponent("item.buddycards.buddysteel_gear.warn"), true);
            return false;
        }
        stack.m_41663_(enchantment, level);
        return true;
    }
}

