/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.client.models.EnderlingModel;
import com.wildcard.buddycards.client.renderer.CardDisplayBlockRenderer;
import com.wildcard.buddycards.client.renderer.CardStandBlockRenderer;
import com.wildcard.buddycards.client.renderer.EnderlingRenderer;
import com.wildcard.buddycards.integration.CuriosIntegration;
import com.wildcard.buddycards.integration.aquaculture.AquacultureIntegration;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsBlocks;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import com.wildcard.buddycards.screen.BinderScreen;
import com.wildcard.buddycards.screen.VaultScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buddycards", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientStuff {
    public static ModelLayerLocation ENDERLING_LAYER = new ModelLayerLocation(new ResourceLocation("buddycards", "enderling"), "enderling");

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)BuddycardsMisc.BINDER_CONTAINER.get()), BinderScreen::new));
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)BuddycardsMisc.VAULT_CONTAINER.get()), VaultScreen::new));
        for (RegistryObject<CardItem> card : BuddycardsItems.ALL_CARDS) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)card.get()), (ResourceLocation)new ResourceLocation("grade"), (stack, world, entity, idk) -> {
                if (stack.m_41783_() != null) {
                    return stack.m_41783_().m_128451_("grade");
                }
                return 0.0f;
            }));
        }
        if (ModList.get().isLoaded("aquaculture")) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)AquacultureIntegration.BUDDYSTEEL_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity, idk) -> {
                if (entity instanceof Player && (entity.m_21120_(InteractionHand.MAIN_HAND) == stack || entity.m_21120_(InteractionHand.OFF_HAND) == stack) && ((Player)entity).f_36083_ != null) {
                    return 1.0f;
                }
                return 0.0f;
            }));
        }
        event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)BuddycardsBlocks.YANNEL.get()), (RenderType)RenderType.m_110463_()));
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.setupRenderers();
        }
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BuddycardsEntities.ENDERLING.get(), EnderlingRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BuddycardsEntities.CARD_DISPLAY_TILE.get(), CardDisplayBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BuddycardsEntities.CARD_STAND_TILE.get(), CardStandBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ENDERLING_LAYER, EnderlingModel::createBodyLayer);
    }
}

