/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.block;

import com.wildcard.buddycards.block.entity.CardDisplayBlockEntity;
import com.wildcard.buddycards.item.BuddycardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CardDisplayBlock
extends BaseEntityBlock {
    public static final DirectionProperty DIR = BlockStateProperties.f_61374_;
    protected static final VoxelShape NSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ESHAPE = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WSHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public CardDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int slot = this.getSlot((Direction)state.m_61143_((Property)DIR), hit.m_82450_());
        if (world.m_7702_(pos) instanceof CardDisplayBlockEntity) {
            CardDisplayBlockEntity displayTile = (CardDisplayBlockEntity)world.m_7702_(pos);
            ItemStack stack = player.m_21120_(hand);
            if (displayTile.getCardInSlot(slot).m_41720_() instanceof BuddycardItem) {
                ItemStack oldCard = displayTile.getCardInSlot(slot);
                if (stack.m_41720_() instanceof BuddycardItem) {
                    ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                    card.m_41751_(stack.m_41783_());
                    displayTile.putCardInSlot(card, slot);
                    stack.m_41774_(1);
                } else {
                    displayTile.putCardInSlot(ItemStack.f_41583_, slot);
                }
                if (!player.m_36356_(oldCard)) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)oldCard);
                }
            } else if (stack.m_41720_() instanceof BuddycardItem) {
                ItemStack card = new ItemStack((ItemLike)stack.m_41720_(), 1);
                card.m_41751_(stack.m_41783_());
                displayTile.putCardInSlot(card, slot);
                stack.m_41774_(1);
            }
        }
        world.m_46717_(pos, (Block)this);
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CardDisplayBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)DIR);
        switch (direction) {
            default: {
                return NSHAPE;
            }
            case EAST: {
                return ESHAPE;
            }
            case SOUTH: {
                return SSHAPE;
            }
            case WEST: 
        }
        return WSHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIR, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIR});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case CLOCKWISE_90: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                }
            }
            case CLOCKWISE_180: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((Direction)state.m_61143_((Property)DIR)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.WEST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.NORTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.EAST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)DIR, (Comparable)Direction.SOUTH);
                    }
                }
            }
        }
        return state;
    }

    private int getSlot(Direction dir, Vec3 hit) {
        hit = new Vec3((hit.f_82479_ < 0.0 ? hit.f_82479_ - Math.floor(hit.f_82479_) : hit.f_82479_) % 1.0, (hit.f_82480_ < 0.0 ? hit.f_82480_ - Math.floor(hit.f_82480_) : hit.f_82480_) % 1.0, (hit.f_82481_ < 0.0 ? hit.f_82481_ - Math.floor(hit.f_82481_) : hit.f_82481_) % 1.0);
        if (hit.f_82480_ > 0.5) {
            if (dir == Direction.NORTH) {
                if (hit.f_82479_ < 0.3333333432674408) {
                    return 1;
                }
                if (hit.f_82479_ < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.EAST) {
                if (hit.f_82481_ < 0.3333333432674408) {
                    return 1;
                }
                if (hit.f_82481_ < 0.6666666865348816) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.SOUTH) {
                if (hit.f_82479_ > 0.6666666865348816) {
                    return 1;
                }
                if (hit.f_82479_ > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
            if (dir == Direction.WEST) {
                if (hit.f_82481_ > 0.6666666865348816) {
                    return 1;
                }
                if (hit.f_82481_ > 0.3333333432674408) {
                    return 2;
                }
                return 3;
            }
        } else {
            if (dir == Direction.NORTH) {
                if (hit.f_82479_ < 0.3333333432674408) {
                    return 4;
                }
                if (hit.f_82479_ < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.EAST) {
                if (hit.f_82481_ < 0.3333333432674408) {
                    return 4;
                }
                if (hit.f_82481_ < 0.6666666865348816) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.SOUTH) {
                if (hit.f_82479_ > 0.6666666865348816) {
                    return 4;
                }
                if (hit.f_82479_ > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
            if (dir == Direction.WEST) {
                if (hit.f_82481_ > 0.6666666865348816) {
                    return 4;
                }
                if (hit.f_82481_ > 0.3333333432674408) {
                    return 5;
                }
                return 6;
            }
        }
        return 1;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (world.m_7702_(pos) instanceof CardDisplayBlockEntity) {
            Containers.m_19010_((Level)world, (BlockPos)pos, ((CardDisplayBlockEntity)world.m_7702_(pos)).getInventory());
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof CardDisplayBlockEntity) {
            return ((CardDisplayBlockEntity)tileentity).getCardsAmt();
        }
        return 0;
    }
}

