/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.datagen;

import com.wildcard.buddycards.core.BuddycardSet;
import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.item.BuddycardItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CardModelGen
extends ItemModelProvider {
    public CardModelGen(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        for (BuddycardItem card : BuddycardsAPI.getAllCards()) {
            this.genCardModel(card.getSet(), card.getCardNumber());
        }
    }

    void genCardModel(BuddycardSet set, int cardNum) {
        String setName = set.getName();
        ResourceLocation location = new ResourceLocation("buddycards", "item/buddycard_" + setName + cardNum);
        ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(location)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/buddycard")))).texture("layer0", new ResourceLocation("buddycards", "item/" + setName + "_set/" + cardNum));
        card.override().predicate(new ResourceLocation("grade"), 1.0f).model(this.genGradedCardModel(setName, cardNum, 1));
        card.override().predicate(new ResourceLocation("grade"), 2.0f).model(this.genGradedCardModel(setName, cardNum, 2));
        card.override().predicate(new ResourceLocation("grade"), 3.0f).model(this.genGradedCardModel(setName, cardNum, 3));
        card.override().predicate(new ResourceLocation("grade"), 4.0f).model(this.genGradedCardModel(setName, cardNum, 4));
        card.override().predicate(new ResourceLocation("grade"), 5.0f).model(this.genGradedCardModel(setName, cardNum, 5));
        this.generatedModels.put(location, card);
    }

    ModelFile genGradedCardModel(String setName, int cardNum, int grade) {
        ResourceLocation location = new ResourceLocation("buddycards", "item/buddycard_" + setName + cardNum + "_g" + grade);
        ItemModelBuilder card = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(location)).parent((ModelFile)this.factory.apply(new ResourceLocation("buddycards", "item/buddycard")))).texture("layer0", new ResourceLocation("buddycards", "item/" + setName + "_set/" + cardNum));
        this.generatedModels.put(location, (ItemModelBuilder)card.texture("layer1", new ResourceLocation("buddycards", "item/grade" + grade)));
        return card;
    }
}

