/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.item;

import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.savedata.BuddycardCollectionSaveData;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BuddycardPackItem
extends Item {
    protected final BuddycardsItems.BuddycardRequirement REQUIREMENT;
    protected final int CARD_AMT;
    protected final int FOIL_AMT;
    protected final SimpleWeightedRandomList<Rarity> rarityWeights;

    public BuddycardPackItem(BuddycardsItems.BuddycardRequirement shouldLoad, int amount, int foils, SimpleWeightedRandomList<Rarity> rarityWeights, Item.Properties properties) {
        super(properties);
        this.REQUIREMENT = shouldLoad;
        this.CARD_AMT = amount;
        this.FOIL_AMT = foils;
        this.rarityWeights = rarityWeights;
        if (this.rarityWeights.m_146337_()) {
            throw new IllegalArgumentException("No rarity weights provided");
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.m_21120_(hand).m_41774_(1);
            NonNullList cards = NonNullList.m_122779_();
            for (int i = 0; i < this.CARD_AMT; ++i) {
                ItemStack card2 = new ItemStack((ItemLike)this.rollCard(level.m_5822_()));
                if (i >= this.CARD_AMT - this.FOIL_AMT) {
                    BuddycardItem.setShiny(card2);
                }
                cards.add((Object)card2);
            }
            cards.forEach(card -> {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)card);
                BuddycardCollectionSaveData.get(serverLevel).addPlayerCardFound(player.m_142081_(), ((BuddycardItem)card.m_41720_()).getSet(), ((BuddycardItem)card.m_41720_()).getCardNumber());
            });
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.REQUIREMENT.shouldLoad()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public BuddycardItem rollCard(Random random) {
        Optional optional = this.rarityWeights.m_146266_(random);
        return optional.map(this::getPossibleCards).map(cards -> (BuddycardItem)((Object)((Object)cards.get(random.nextInt(cards.size()))))).orElseThrow(() -> new IllegalStateException("Cardpack " + this.getRegistryName() + " does not contain cards for rarity"));
    }

    public abstract List<BuddycardItem> getPossibleCards(Rarity var1);
}

