/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.client.renderer.MedalRenderer;
import com.wildcard.buddycards.item.IMedalTypes;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosIntegration {
    public static void imc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("medal").icon(new ResourceLocation("buddycards", "misc/medal")).build());
    }

    public static ICapabilityProvider initCapabilities(final IMedalTypes type, final ItemStack itemStack) {
        final ICurio curio = new ICurio(){

            public boolean canRightClickEquip() {
                return true;
            }

            public ItemStack getStack() {
                return itemStack;
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player) {
                    int mod = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BuddycardsMisc.BUDDY_BOOST.get()), (ItemStack)itemStack);
                    type.applyEffect((Player)livingEntity, mod);
                }
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void LoadTextures(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("buddycards", "misc/medal"));
    }

    public static void setupRenderers() {
        CuriosRendererRegistry.register((Item)((Item)BuddycardsItems.MEDAL_BASE.get()), () -> new MedalRenderer(CuriosIntegration.getDefaultMedalTexture("buddysteel_medal_base")));
        CuriosRendererRegistry.register((Item)((Item)BuddycardsItems.MEDAL_NETHER.get()), () -> new MedalRenderer(CuriosIntegration.getDefaultMedalTexture("buddysteel_medal_nether")));
        CuriosRendererRegistry.register((Item)((Item)BuddycardsItems.MEDAL_END.get()), () -> new MedalRenderer(CuriosIntegration.getDefaultMedalTexture("buddysteel_medal_end")));
    }

    protected static ResourceLocation getDefaultMedalTexture(String name) {
        return new ResourceLocation("buddycards", "textures/models/medal/" + name + ".png");
    }
}

