/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.block;

import com.tm.calemieconomy.block.BlockCurrencyNetworkCableOpaque;
import com.tm.calemieconomy.blockentity.ICurrencyNetwork;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCurrencyNetworkCable
extends BlockCurrencyNetworkCableOpaque {
    private static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final BooleanProperty DOWNUP = BooleanProperty.m_61465_((String)"downup");
    private static final BooleanProperty NORTHSOUTH = BooleanProperty.m_61465_((String)"northsouth");
    private static final BooleanProperty EASTWEST = BooleanProperty.m_61465_((String)"eastwest");
    private static final VoxelShape CORE_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)5.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWNUP_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTHSOUTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape EASTWEST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public BlockCurrencyNetworkCable() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWNUP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(false)));
    }

    private boolean canCableConnectTo(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockPos otherPos = pos.m_142300_(facing);
        return this.canBeConnectedTo(level, otherPos, facing.m_122424_());
    }

    private boolean canBeConnectedTo(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ICurrencyNetwork) {
            ICurrencyNetwork currencyNetwork = (ICurrencyNetwork)blockEntity;
            for (Direction dir : currencyNetwork.getConnectedDirections()) {
                if (facing != dir) continue;
                return true;
            }
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState getState(LevelAccessor world, BlockPos pos) {
        boolean eastwest;
        boolean down = this.canCableConnectTo(world, pos, Direction.DOWN);
        boolean up = this.canCableConnectTo(world, pos, Direction.UP);
        boolean north = this.canCableConnectTo(world, pos, Direction.NORTH);
        boolean east = this.canCableConnectTo(world, pos, Direction.EAST);
        boolean south = this.canCableConnectTo(world, pos, Direction.SOUTH);
        boolean west = this.canCableConnectTo(world, pos, Direction.WEST);
        boolean downup = down && up && !north && !east && !south && !west;
        boolean northsouth = north && south && !down && !up && !east && !west;
        boolean bl = eastwest = east && west && !north && !south && !down && !up;
        if (downup || northsouth || eastwest) {
            down = false;
            up = false;
            north = false;
            east = false;
            south = false;
            west = false;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)DOWNUP, (Comparable)Boolean.valueOf(downup))).m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(northsouth))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(eastwest));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return this.getState(level, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, DOWNUP, NORTHSOUTH, EASTWEST});
    }

    private VoxelShape getCollision(BlockState state) {
        ArrayList<VoxelShape> collidingBoxes = new ArrayList<VoxelShape>();
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            collidingBoxes.add(DOWN_AABB);
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            collidingBoxes.add(UP_AABB);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            collidingBoxes.add(NORTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            collidingBoxes.add(EAST_AABB);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            collidingBoxes.add(SOUTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            collidingBoxes.add(WEST_AABB);
        }
        if (((Boolean)state.m_61143_((Property)DOWNUP)).booleanValue()) {
            collidingBoxes.add(DOWNUP_AABB);
        }
        if (((Boolean)state.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
            collidingBoxes.add(NORTHSOUTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)EASTWEST)).booleanValue()) {
            collidingBoxes.add(EASTWEST_AABB);
        }
        if (!(((Boolean)state.m_61143_((Property)DOWNUP)).booleanValue() || ((Boolean)state.m_61143_((Property)NORTHSOUTH)).booleanValue() || ((Boolean)state.m_61143_((Property)EASTWEST)).booleanValue())) {
            collidingBoxes.add(CORE_AABB);
        }
        VoxelShape[] shapes = new VoxelShape[collidingBoxes.size()];
        for (int i = 0; i < shapes.length; ++i) {
            shapes[i] = (VoxelShape)collidingBoxes.get(i);
        }
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), (VoxelShape[])shapes);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCollision(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCollision(state);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }
}

