/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tm.calemicore.util.helper.MathHelper;
import com.tm.calemicore.util.menu.MenuBase;
import com.tm.calemicore.util.screen.ScreenContainerBase;
import com.tm.calemicore.util.screen.widget.SmoothButton;
import com.tm.calemieconomy.blockentity.BlockEntityBank;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.menu.MenuBank;
import com.tm.calemieconomy.packet.CEPacketHandler;
import com.tm.calemieconomy.packet.PacketBank;
import com.tm.calemieconomy.util.helper.ScreenTabs;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBank
extends ScreenContainerBase<MenuBank> {
    private final BlockEntityBank bank;

    public ScreenBank(MenuBank menu, Inventory playerInv, Component useless) {
        super((MenuBase)menu, playerInv, menu.getBlockEntity().m_5446_());
        this.textureLocation = new ResourceLocation("calemieconomy", "textures/gui/bank.png");
        this.bank = (BlockEntityBank)((MenuBank)this.m_6262_()).getBlockEntity();
        this.f_97731_ = Integer.MAX_VALUE;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new SmoothButton(this.getScreenX() + this.f_97726_ / 2 + 30 - 25, this.getScreenY() + 40, 50, "screen.bank.btn.withdraw", btn -> this.withdraw()));
        this.m_142416_((GuiEventListener)new SmoothButton(this.getScreenX() + this.f_97726_ / 2 - 30 - 25, this.getScreenY() + 40, 50, "screen.bank.btn.deposit", btn -> this.deposit()));
    }

    private void withdraw() {
        Item item = this.bank.m_8020_(1).m_41720_();
        if (item instanceof ItemWallet) {
            ItemWallet wallet = (ItemWallet)item;
            ItemStack walletStack = this.bank.m_8020_(1);
            int walletCurrency = wallet.getCurrency(walletStack);
            int amountToAdd = MathHelper.getAmountToAdd((int)walletCurrency, (int)this.bank.getCurrency(), (int)wallet.getCurrencyCapacity());
            if (amountToAdd > 0) {
                this.bank.withdrawCurrency(amountToAdd);
                wallet.depositCurrency(walletStack, amountToAdd);
            } else {
                int remainder = MathHelper.getAmountToFill((int)walletCurrency, (int)this.bank.getCurrency(), (int)wallet.getCurrencyCapacity());
                if (remainder > 0) {
                    this.bank.withdrawCurrency(amountToAdd);
                    wallet.depositCurrency(walletStack, amountToAdd);
                }
            }
            CEPacketHandler.INSTANCE.sendToServer((Object)new PacketBank(this.bank.getCurrency(), wallet.getCurrency(walletStack), this.bank.m_58899_()));
        }
    }

    private void deposit() {
        Item item = this.bank.m_8020_(1).m_41720_();
        if (item instanceof ItemWallet) {
            ItemWallet wallet = (ItemWallet)item;
            ItemStack walletStack = this.bank.m_8020_(1);
            int walletCurrency = wallet.getCurrency(walletStack);
            int amountToAdd = MathHelper.getAmountToAdd((int)this.bank.getCurrency(), (int)walletCurrency, (int)this.bank.getCurrencyCapacity());
            if (amountToAdd > 0) {
                this.bank.depositCurrency(amountToAdd);
                wallet.withdrawCurrency(walletStack, amountToAdd);
            } else {
                int remainder = MathHelper.getAmountToFill((int)this.bank.getCurrency(), (int)walletCurrency, (int)this.bank.getCurrencyCapacity());
                if (remainder > 0) {
                    this.bank.depositCurrency(remainder);
                    wallet.withdrawCurrency(walletStack, remainder);
                }
            }
            CEPacketHandler.INSTANCE.sendToServer((Object)new PacketBank(this.bank.getCurrency(), wallet.getCurrency(walletStack), this.bank.m_58899_()));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ScreenTabs.addCurrencyTab(poseStack, this.getScreenX(), this.getScreenY() + 5, mouseX, mouseY, this.bank);
        if (!this.bank.isOnlyConnectedBank()) {
            ScreenTabs.addIconTab(poseStack, 13, 0, this.getScreenX(), this.getScreenY() + 21, mouseX, mouseY, new TranslatableComponent("screen.bank.error.1"), new TranslatableComponent("screen.bank.error.2"));
        }
    }
}

