/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tm.calemicore.util.helper.MathHelper;
import com.tm.calemicore.util.helper.ScreenHelper;
import com.tm.calemicore.util.helper.StringHelper;
import com.tm.calemicore.util.menu.MenuBase;
import com.tm.calemicore.util.screen.ScreenContainerBase;
import com.tm.calemicore.util.screen.ScreenRect;
import com.tm.calemicore.util.screen.widget.SmoothButton;
import com.tm.calemieconomy.init.InitItems;
import com.tm.calemieconomy.item.ItemCoin;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.menu.MenuWallet;
import com.tm.calemieconomy.packet.CEPacketHandler;
import com.tm.calemieconomy.packet.PacketExtractWalletCurrency;
import com.tm.calemieconomy.util.IItemCurrencyHolder;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import com.tm.calemieconomy.util.helper.ScreenTabs;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ScreenWallet
extends ScreenContainerBase<MenuWallet> {
    private final ResourceLocation textureLocation = new ResourceLocation("calemieconomy", "textures/gui/wallet.png");
    private final Player player;

    public ScreenWallet(MenuWallet menu, Inventory playerInv, Component title) {
        super((MenuBase)menu, playerInv, title);
        this.player = playerInv.f_35978_;
        this.f_97731_ = Integer.MAX_VALUE;
        this.f_97727_ = 176;
    }

    public int getScreenX() {
        return (this.f_96543_ - this.f_97726_) / 2;
    }

    public int getScreenY() {
        return (this.f_96544_ - this.f_97727_) / 2;
    }

    private ItemStack getCurrentWalletStack() {
        ItemStack walletStack = CurrencyHelper.getCurrentWallet(this.player);
        if (!walletStack.m_41619_()) {
            return walletStack;
        }
        this.player.m_6915_();
        return ItemStack.f_41583_;
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int index = 0; index < 4; ++index) {
            int id = index;
            this.m_142416_((GuiEventListener)new SmoothButton(this.getScreenX() + 146, this.getScreenY() + 15 + index * 18, 16, "+", btn -> this.addMoney(id)));
        }
    }

    private void addMoney(int id) {
        ItemStack walletStack = this.getCurrentWalletStack();
        if (!walletStack.m_41619_()) {
            ItemWallet walletItem = (ItemWallet)walletStack.m_41720_();
            int price = ((ItemCoin)InitItems.COIN_COPPER.get()).value;
            if (id == 1) {
                price = ((ItemCoin)InitItems.COIN_SILVER.get()).value;
            } else if (id == 2) {
                price = ((ItemCoin)InitItems.COIN_GOLD.get()).value;
            } else if (id == 3) {
                price = ((ItemCoin)InitItems.COIN_PLATINUM.get()).value;
            }
            int multiplier = MathHelper.getShiftCtrlInt((int)1, (int)16, (int)64, (int)576);
            if (walletItem.getCurrency(walletStack) >= (price *= multiplier)) {
                CEPacketHandler.INSTANCE.sendToServer((Object)new PacketExtractWalletCurrency(id, multiplier));
                walletItem.withdrawCurrency(walletStack, price);
            }
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        Item item;
        if (this.textureLocation != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureLocation);
            ScreenHelper.drawRect((int)0, (int)0, (ScreenRect)new ScreenRect(this.getScreenX(), this.getScreenY(), this.f_97726_, this.f_97727_), (int)0);
        }
        ScreenHelper.drawItemStack((ItemRenderer)this.f_96542_, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_COPPER.get()), (int)(this.getScreenX() + 127), (int)(this.getScreenY() + 15));
        ScreenHelper.drawItemStack((ItemRenderer)this.f_96542_, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_SILVER.get()), (int)(this.getScreenX() + 127), (int)(this.getScreenY() + 33));
        ScreenHelper.drawItemStack((ItemRenderer)this.f_96542_, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_GOLD.get()), (int)(this.getScreenX() + 127), (int)(this.getScreenY() + 51));
        ScreenHelper.drawItemStack((ItemRenderer)this.f_96542_, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_PLATINUM.get()), (int)(this.getScreenX() + 127), (int)(this.getScreenY() + 69));
        ItemStack stack = this.getCurrentWalletStack();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IItemCurrencyHolder) {
            IItemCurrencyHolder currencyHolder = (IItemCurrencyHolder)item;
            ScreenHelper.drawCenteredString((PoseStack)poseStack, (int)(this.getScreenX() + this.getXSize() / 2 - 16), (int)(this.getScreenY() + 42), (int)0, (int)0x555555, (MutableComponent)new TextComponent(StringHelper.insertCommas((int)currencyHolder.getCurrency(stack))));
            ScreenHelper.drawCenteredString((PoseStack)poseStack, (int)(this.getScreenX() + this.getXSize() / 2 - 16), (int)(this.getScreenY() + 51), (int)0, (int)0x555555, (MutableComponent)new TranslatableComponent("ce.rc"));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
        ScreenTabs.addIconTab(poseStack, 0, 0, this.getScreenX(), this.getScreenY() + 5, mouseX, mouseY, new TranslatableComponent("screen.tab.info.1"), new TranslatableComponent("screen.tab.info.2"));
    }
}

