/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util;

import com.tm.calemicore.util.Location;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeBlockState;

public class BlockScanner {
    public final ArrayList<Location> buffer = new ArrayList();
    public final Location origin;
    public final IForgeBlockState blockToScan;
    public final int maxScanSize;
    public final boolean useDefaultState;

    public BlockScanner(Location origin, IForgeBlockState blockToScan, int maxScanSize, boolean useDefaultState) {
        this.origin = origin;
        this.blockToScan = blockToScan;
        this.maxScanSize = maxScanSize;
        this.useDefaultState = useDefaultState;
    }

    public void startVeinScan() {
        this.reset();
        this.scan(this.origin, false);
    }

    public void startRadiusScan() {
        this.reset();
        this.scan(this.origin, true);
    }

    public void reset() {
        this.buffer.clear();
    }

    public void scan(Location location, boolean isRadiusScan) {
        block8: {
            BlockState state;
            if (this.buffer.size() >= this.maxScanSize) {
                return;
            }
            if (this.buffer.contains(location) || location.getBlock() == null) break block8;
            BlockState blockState = state = this.useDefaultState ? location.getBlockState().m_60734_().m_49966_() : location.getBlockState();
            if (state != this.blockToScan) {
                return;
            }
            this.buffer.add(location);
            if (isRadiusScan) {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            Location nextLocation = new Location(location.level, location.x + x, location.y + y, location.z + z);
                            this.scan(nextLocation, isRadiusScan);
                        }
                    }
                }
            } else {
                for (Direction dir : Direction.values()) {
                    this.scan(new Location(location, dir), isRadiusScan);
                }
            }
        }
    }

    public boolean contains(Location location) {
        for (Location nextLocation : this.buffer) {
            if (!nextLocation.equals(location)) continue;
            return true;
        }
        return false;
    }
}

