/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util;

import com.tm.calemicore.util.helper.SoundHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.util.FakePlayer;

public class Location {
    public final Level level;
    public int x;
    public int y;
    public int z;
    private BlockPos blockPos;

    public Location(Level level, BlockPos pos) {
        this(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Location(Level level, int x, int y, int z) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockPos = new BlockPos(x, y, z);
    }

    public Location(BlockEntity blockEntity) {
        this(blockEntity.m_58904_(), blockEntity.m_58899_().m_123341_(), blockEntity.m_58899_().m_123342_(), blockEntity.m_58899_().m_123343_());
    }

    public Location(Entity entity) {
        this(entity.f_19853_, entity.m_146903_(), entity.m_146904_(), entity.m_146907_());
    }

    public Location(Location location, Direction dir) {
        this(location, dir, 1);
    }

    public Location(Location location, Direction dir, int distance) {
        this.level = location.level;
        this.x = location.x + dir.m_122429_() * distance;
        this.y = location.y + dir.m_122430_() * distance;
        this.z = location.z + dir.m_122431_() * distance;
        this.blockPos = new BlockPos(this.x, this.y, this.z);
    }

    public void translate(Direction dir, int distance) {
        this.x += dir.m_122429_() * distance;
        this.y += dir.m_122430_() * distance;
        this.z += dir.m_122431_() * distance;
        this.blockPos = new BlockPos(this.x, this.y, this.z);
    }

    public Location copy() {
        return new Location(this.level, this.x, this.y, this.z);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        return this.level.m_8055_(this.blockPos);
    }

    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    public Material getBlockMaterial() {
        return this.getBlockState().m_60767_();
    }

    public List<ItemStack> getDrops(Player player, ItemStack heldStack) {
        return Block.m_49874_((BlockState)this.getBlockState(), (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos(), null, (Entity)player, (ItemStack)heldStack);
    }

    public int getLightValue() {
        return this.level.m_7146_(this.getBlockPos());
    }

    public BlockEntity getBlockEntity() {
        return this.level.m_7702_(this.getBlockPos());
    }

    public double getDistance(Location location) {
        int dx = this.x - location.x;
        int dy = this.y - location.y;
        int dz = this.z - location.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Vec3 getVector() {
        return new Vec3((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    public void setBlock(Block block) {
        this.level.m_7731_(this.getBlockPos(), block.m_49966_(), 2);
    }

    public void setBlock(BlockState state) {
        this.setBlock(state.m_60734_());
        this.level.m_7731_(this.getBlockPos(), state, 2);
    }

    public void setBlock(BlockState state, Player placer) {
        this.level.m_7731_(this.getBlockPos(), state, 2);
        state.m_60734_().m_6402_(this.level, this.getBlockPos(), state, (LivingEntity)placer, new ItemStack((ItemLike)state.m_60734_()));
    }

    public void setBlock(BlockPlaceContext context, Block block) {
        this.setBlock(block.m_5573_(context));
    }

    public void setBlockToAir() {
        this.setBlock(Blocks.f_50016_);
    }

    public void breakBlock(Player breaker) {
        if (breaker instanceof FakePlayer) {
            return;
        }
        SoundHelper.playBlockBreak(this, this.getBlockState());
        if (breaker instanceof ServerPlayer) {
            ((ServerPlayer)breaker).f_8941_.m_9280_(this.blockPos);
        }
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public boolean isAirBlock() {
        return this.getBlock() == Blocks.f_50016_;
    }

    public boolean isBlockValidForPlacing() {
        return this.getBlockMaterial().m_76336_() || this.isAirBlock();
    }

    public boolean isFullCube() {
        return this.getBlockState().m_60838_((BlockGetter)this.level, this.getBlockPos());
    }

    public boolean isEntityAtLocation(Entity entity) {
        int entityX = entity.m_146903_();
        int entityY = entity.m_146904_();
        int entityZ = entity.m_146907_();
        return entityX == this.x && entityZ == this.z && (entityY == this.y || entityY + 1 == this.y);
    }

    public boolean doesBlockHaveCollision() {
        return this.getBlock().m_5939_(this.getBlockState(), (BlockGetter)this.level, this.getBlockPos(), CollisionContext.m_82749_()) != Shapes.m_83040_();
    }

    public static Location readFromNBT(Level level, CompoundTag tag) {
        if (!(tag.m_128441_("locX") && tag.m_128441_("locY") && tag.m_128441_("locZ"))) {
            return null;
        }
        int x = tag.m_128451_("locX");
        int y = tag.m_128451_("locY");
        int z = tag.m_128451_("locZ");
        return new Location(level, x, y, z);
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("locX", this.x);
        tag.m_128405_("locY", this.y);
        tag.m_128405_("locZ", this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location newLoc = (Location)obj;
            return this.level == newLoc.level && this.x == newLoc.x && this.y == newLoc.y && this.z == newLoc.z;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

