/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static void onFinishedLoading() {
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            ForgeConfigSpec commonSpec;
            if (container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent()) {
                return;
            }
            EnumMap<ModConfig.Type, ModConfig> configs = ClientHandler.getConfigMap(container);
            ModConfig clientConfig = configs.get(ModConfig.Type.CLIENT);
            if (OptiFineHelper.isLoaded() && modId.equals("forge")) {
                Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
                clientConfig = null;
            }
            ModConfig commonConfig = configs.get(ModConfig.Type.COMMON);
            ForgeConfigSpec clientSpec = clientConfig != null ? clientConfig.getSpec() : null;
            ForgeConfigSpec forgeConfigSpec = commonSpec = commonConfig != null ? commonConfig.getSpec() : null;
            if (clientSpec != null || commonSpec != null) {
                Configured.LOGGER.info("Registering config factory for mod {} (client: {}, common: {})", modId, (Object)(clientSpec != null ? 1 : 0), (Object)(commonSpec != null ? 1 : 0));
                ResourceLocation background = AbstractGui.BACKGROUND_LOCATION;
                if (container.getModInfo() instanceof ModInfo) {
                    Optional optional;
                    String configBackground = (String)container.getModInfo().getModProperties().get("configuredBackground");
                    if (configBackground == null && (optional = ((ModInfo)container.getModInfo()).getConfigElement(new String[]{"configBackground"})).isPresent()) {
                        configBackground = (String)optional.get();
                    }
                    if (configBackground != null) {
                        background = new ResourceLocation(configBackground);
                    }
                }
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation finalBackground = background;
                container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigScreen((Screen)screen, displayName, clientSpec, commonSpec, finalBackground));
            }
        });
    }

    private static EnumMap<ModConfig.Type, ModConfig> getConfigMap(ModContainer container) {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)container, (String)"configs");
    }
}

