/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.EditStringListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    public static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("configured", "textures/gui/logo.png");
    public static final Comparator<Entry> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof SubMenu && o2 instanceof SubMenu) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof SubMenu) && o2 instanceof SubMenu) {
            return 1;
        }
        if (o1 instanceof SubMenu) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    private final Screen parent;
    private final String displayName;
    private final ForgeConfigSpec clientSpec;
    private final UnmodifiableConfig clientValues;
    private final ForgeConfigSpec commonSpec;
    private final UnmodifiableConfig commonValues;
    private final ResourceLocation background;
    private ConfigList list;
    private List<Entry> entries;
    private ConfigTextFieldWidget activeTextField;
    private ConfigTextFieldWidget searchTextField;
    private Button restoreDefaultsButton;
    private boolean subMenu = false;
    private List<String> activeTooltip;
    private final List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> allConfigValues;

    public ConfigScreen(Screen parent, String displayName, ForgeConfigSpec spec, UnmodifiableConfig values, ResourceLocation background) {
        super((ITextComponent)new StringTextComponent(displayName));
        this.parent = parent;
        this.displayName = displayName;
        this.clientSpec = spec;
        this.clientValues = values;
        this.commonSpec = null;
        this.commonValues = null;
        this.subMenu = true;
        this.allConfigValues = null;
        this.background = background;
    }

    public ConfigScreen(Screen parent, String displayName, @Nullable ForgeConfigSpec clientSpec, @Nullable ForgeConfigSpec commonSpec, ResourceLocation background) {
        super((ITextComponent)new StringTextComponent(displayName));
        this.parent = parent;
        this.displayName = displayName;
        this.clientSpec = clientSpec;
        this.clientValues = clientSpec != null ? clientSpec.getValues() : null;
        this.commonSpec = commonSpec;
        this.commonValues = commonSpec != null ? commonSpec.getValues() : null;
        this.allConfigValues = this.gatherAllConfigValues();
        this.background = background;
    }

    private List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues() {
        ArrayList values = new ArrayList();
        if (this.clientValues != null) {
            this.gatherValuesFromConfig(this.clientValues, this.clientSpec, values);
        }
        if (this.commonValues != null) {
            this.gatherValuesFromConfig(this.commonValues, this.commonSpec, values);
        }
        return ImmutableList.copyOf(values);
    }

    private void gatherValuesFromConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                this.gatherValuesFromConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    private void constructEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.clientValues != null && this.clientSpec != null) {
            if (!this.subMenu) {
                entries.add(new TitleEntry("Client Configuration"));
            }
            this.createEntriesFromConfig(this.clientValues, this.clientSpec, entries);
        }
        if (this.commonValues != null && this.commonSpec != null) {
            entries.add(new TitleEntry("Common Configuration"));
            this.createEntriesFromConfig(this.commonValues, this.commonSpec, entries);
        }
        this.entries = ImmutableList.copyOf(entries);
    }

    private void createEntriesFromConfig(UnmodifiableConfig values, ForgeConfigSpec spec, List<Entry> entries) {
        ArrayList<Entry> subEntries = new ArrayList<Entry>();
        values.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                subEntries.add(new SubMenu((String)s, spec, (AbstractConfig)o));
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                Object value = configValue.get();
                if (value instanceof Boolean) {
                    subEntries.add(new BooleanEntry((ForgeConfigSpec.ConfigValue<Boolean>)configValue, valueSpec));
                } else if (value instanceof Integer) {
                    subEntries.add(new IntegerEntry((ForgeConfigSpec.ConfigValue<Integer>)configValue, valueSpec));
                } else if (value instanceof Double) {
                    subEntries.add(new DoubleEntry((ForgeConfigSpec.ConfigValue<Double>)configValue, valueSpec));
                } else if (value instanceof Long) {
                    subEntries.add(new LongEntry((ForgeConfigSpec.ConfigValue<Long>)configValue, valueSpec));
                } else if (value instanceof Enum) {
                    subEntries.add(new EnumEntry((ForgeConfigSpec.ConfigValue<Enum>)configValue, valueSpec));
                } else if (value instanceof String) {
                    subEntries.add(new StringEntry((ForgeConfigSpec.ConfigValue<String>)configValue, valueSpec));
                } else if (value instanceof List) {
                    subEntries.add(new ListStringEntry(configValue, valueSpec));
                } else {
                    Configured.LOGGER.info("Unsupported config value: " + configValue.getPath());
                }
            }
        });
        subEntries.sort(COMPARATOR);
        entries.addAll(subEntries);
    }

    protected void init() {
        this.constructEntries();
        this.list = new ConfigList(this.entries);
        this.children.add(this.list);
        this.searchTextField = new ConfigTextFieldWidget(this.font, this.width / 2 - 110, 22, 220, 20, (ITextComponent)new StringTextComponent("Search"));
        this.searchTextField.func_212954_a(s -> {
            if (!s.isEmpty()) {
                this.list.replaceEntries(this.entries.stream().filter(entry -> (entry instanceof SubMenu || entry instanceof ConfigEntry) && entry.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            } else {
                this.list.replaceEntries(this.entries);
            }
        });
        this.children.add(this.searchTextField);
        if (this.subMenu) {
            this.addButton((Widget)new Button(this.width / 2 - 75, this.height - 29, 150, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]), button -> this.minecraft.func_147108_a(this.parent)));
        } else {
            this.addButton((Widget)new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
                if (this.clientSpec != null) {
                    this.clientSpec.save();
                }
                if (this.commonSpec != null) {
                    this.commonSpec.save();
                }
                this.minecraft.func_147108_a(this.parent);
            }));
            this.restoreDefaultsButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 29, 150, 20, I18n.func_135052_a((String)"configured.gui.restore_defaults", (Object[])new Object[0]), button -> {
                if (this.allConfigValues == null) {
                    return;
                }
                this.allConfigValues.forEach(pair -> {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)pair.getLeft();
                    ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)pair.getRight();
                    configValue.set(valueSpec.getDefault());
                });
                this.entries.stream().filter(entry -> entry instanceof ConfigEntry).forEach(entry -> ((ConfigEntry)((Object)((Object)entry))).onResetValue());
            }));
            this.updateRestoreDefaultButton();
        }
    }

    public void tick() {
        this.updateRestoreDefaultButton();
    }

    private void updateRestoreDefaultButton() {
        if (this.allConfigValues != null && this.restoreDefaultsButton != null) {
            this.restoreDefaultsButton.active = this.allConfigValues.stream().anyMatch(pair -> !((ForgeConfigSpec.ConfigValue)pair.getLeft()).get().equals(((ForgeConfigSpec.ValueSpec)pair.getRight()).getDefault()));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.renderBackground();
        this.list.render(mouseX, mouseY, partialTicks);
        this.searchTextField.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 7, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        this.minecraft.func_110434_K().func_110577_a(LOGO_TEXTURE);
        ConfigScreen.blit((int)10, (int)13, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(this.minecraft.field_71466_p.func_78271_c(I18n.func_135052_a((String)"configured.gui.info", (Object[])new Object[0]), 200));
        }
        if (this.activeTooltip != null) {
            this.renderTooltip(this.activeTooltip, mouseX, mouseY);
        }
        this.children().forEach(o -> {
            if (o instanceof IconButton.Tooltip) {
                ((IconButton.Tooltip)o).onTooltip((Button)o, mouseX, mouseY);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            ITextComponent placeholder = new StringTextComponent("").func_150255_a(style);
            this.handleComponentClicked(placeholder);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setActiveTooltip(List<String> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    private static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    private static String createLabelFromConfig(ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        if (valueSpec.getTranslationKey() != null) {
            return new TranslationTextComponent(valueSpec.getTranslationKey(), new Object[0]).getString();
        }
        return ConfigScreen.createLabel(ConfigScreen.lastValue(configValue.getPath(), ""));
    }

    private static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public void renderDirtBackground(int vOffset) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(this.background);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float size = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(0.0, (double)this.height, 0.0).func_225583_a_(0.0f, (float)this.height / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.width, (double)this.height, 0.0).func_225583_a_((float)this.width / size, (float)this.height / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.width, 0.0, 0.0).func_225583_a_((float)this.width / size, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigTextFieldWidget
    extends TextFieldWidget {
        public ConfigTextFieldWidget(FontRenderer fontRenderer, int x, int y, int width, int height, ITextComponent label) {
            super(fontRenderer, x, y, width, height, label.func_150254_d());
        }

        public void func_146195_b(boolean focused) {
            super.func_146195_b(focused);
            if (focused) {
                if (ConfigScreen.this.activeTextField != null && ConfigScreen.this.activeTextField != this) {
                    ConfigScreen.this.activeTextField.func_146195_b(false);
                    ConfigScreen.this.activeTextField = this;
                } else {
                    ConfigScreen.this.activeTextField = this;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EnumEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<Enum>> {
        private final Button button;

        public EnumEntry(ForgeConfigSpec.ConfigValue<Enum> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, new StringTextComponent(((Enum)configValue.get()).name()).func_150265_g(), button -> {
                Object o = configValue.get();
                if (o instanceof Enum) {
                    Enum e = (Enum)o;
                    E[] values = e.getDeclaringClass().getEnumConstants();
                    e = (Enum)values[(e.ordinal() + 1) % values.length];
                    configValue.set((Object)e);
                    button.setMessage(new StringTextComponent(e.name()).func_150265_g());
                }
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.x = left + width - 67;
            this.button.y = top;
            this.button.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.setMessage(new StringTextComponent(((Enum)this.configValue.get()).name()).func_150265_g());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ListStringEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<List<?>>> {
        private final Button button;

        public ListStringEntry(ForgeConfigSpec.ConfigValue<List<?>> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            String title = ConfigScreen.createLabelFromConfig(configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, new TranslationTextComponent("configured.gui.edit", new Object[0]).func_150254_d(), button -> ConfigScreen.this.minecraft.func_147108_a((Screen)new EditStringListScreen(ConfigScreen.this, (ITextComponent)new StringTextComponent(title), configValue, valueSpec)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.x = left + width - 67;
            this.button.y = top;
            this.button.render(mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class StringEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<String>> {
        private final Button button;

        public StringEntry(ForgeConfigSpec.ConfigValue<String> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            String title = ConfigScreen.createLabelFromConfig(configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, new TranslationTextComponent("configured.gui.edit", new Object[0]).func_150254_d(), button -> ConfigScreen.this.minecraft.func_147108_a((Screen)new EditStringScreen(ConfigScreen.this, (ITextComponent)new StringTextComponent(title), (String)configValue.get(), arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), arg_0 -> ((ForgeConfigSpec.ConfigValue)configValue).set(arg_0))));
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.x = left + width - 67;
            this.button.y = top;
            this.button.render(mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<Boolean>> {
        private final Button button;

        public BooleanEntry(ForgeConfigSpec.ConfigValue<Boolean> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, this.getLabel(), button -> {
                boolean flag = (Boolean)configValue.get() == false;
                configValue.set((Object)flag);
                button.setMessage(this.getLabel());
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.x = left + width - 67;
            this.button.y = top;
            this.button.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.setMessage(this.getLabel());
        }

        @Override
        public String getLabel() {
            return I18n.func_135052_a((String)((Boolean)this.configValue.get() != false ? "options.on" : "options.off"), (Object[])new Object[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LongEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Long>> {
        public LongEntry(ForgeConfigSpec.ConfigValue<Long> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Long::parseLong);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class DoubleEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Double>> {
        public DoubleEntry(ForgeConfigSpec.ConfigValue<Double> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Double::parseDouble);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class IntegerEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Integer>> {
        public IntegerEntry(ForgeConfigSpec.ConfigValue<Integer> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Integer::parseInt);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class NumberEntry<T extends ForgeConfigSpec.ConfigValue>
    extends ConfigEntry<T> {
        private ConfigTextFieldWidget textField;
        final /* synthetic */ ConfigScreen this$0;

        public NumberEntry(T configValue, ForgeConfigSpec.ValueSpec valueSpec, Function<String, Number> parser) {
            this.this$0 = this$0;
            super((ConfigScreen)this$0, configValue, valueSpec);
            this.textField = this$0.new ConfigTextFieldWidget(((ConfigScreen)this$0).font, 0, 0, 42, 18, (ITextComponent)new StringTextComponent("YEP"));
            this.textField.func_146180_a(configValue.get().toString());
            this.textField.func_212954_a(s -> {
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (valueSpec.test((Object)n)) {
                        this.textField.func_146193_g(0xE0E0E0);
                        configValue.set((Object)n);
                    } else {
                        this.textField.func_146193_g(0xFF0000);
                    }
                }
                catch (Exception ignored) {
                    this.textField.func_146193_g(0xFF0000);
                }
            });
            this.eventListeners.add(this.textField);
        }

        @Override
        public void render(int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.textField.x = left + width - 66;
            this.textField.y = top + 1;
            this.textField.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.func_146180_a(this.configValue.get().toString());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigList
    extends AbstractOptionList<Entry> {
        public ConfigList(List<Entry> entries) {
            super(ConfigScreen.this.minecraft, ConfigScreen.this.width, ConfigScreen.this.height, 50, ConfigScreen.this.height - 36, 24);
            entries.forEach(arg_0 -> ((ConfigList)this).addEntry(arg_0));
        }

        public int getRowLeft() {
            return super.getRowLeft();
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 144;
        }

        public int getRowWidth() {
            return 260;
        }

        public void replaceEntries(Collection<Entry> entries) {
            super.replaceEntries(entries);
        }

        private void renderToolTips(int mouseX, int mouseY) {
            Entry entry2;
            if (this.isMouseOver(mouseX, mouseY) && mouseX < ConfigScreen.this.list.getRowLeft() + ConfigScreen.this.list.getRowWidth() - 67 && (entry2 = (Entry)this.getEntryAtPosition(mouseX, mouseY)) != null) {
                ConfigScreen.this.setActiveTooltip(entry2.tooltip);
            }
            this.children().forEach(entry -> entry.children().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).renderToolTip(mouseX, mouseY);
                }
            }));
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            int scrollBarStart = this.getScrollbarPosition();
            int scrollBarEnd = scrollBarStart + 6;
            this.minecraft.func_110434_K().func_110577_a(ConfigScreen.this.background);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
            int rowLeft = this.getRowLeft();
            int scrollOffset = this.y0 + 4 - (int)this.getScrollAmount();
            this.renderList(rowLeft, scrollOffset, mouseX, mouseY, partialTicks);
            this.minecraft.func_110434_K().func_110577_a(ConfigScreen.this.background);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.x0, (double)this.y0, -100.0).func_225583_a_(0.0f, (float)this.y0 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.x0 + this.width), (double)this.y0, -100.0).func_225583_a_((float)this.width / 32.0f, (float)this.y0 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.x0 + this.width), 0.0, -100.0).func_225583_a_((float)this.width / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, 0.0, -100.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)this.height, -100.0).func_225583_a_(0.0f, (float)this.height / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.x0 + this.width), (double)this.height, -100.0).func_225583_a_((float)this.width / 32.0f, (float)this.height / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.x0 + this.width), (double)this.y1, -100.0).func_225583_a_((float)this.width / 32.0f, (float)this.y1 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)this.y1, -100.0).func_225583_a_(0.0f, (float)this.y1 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.x0, (double)(this.y0 + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)(this.y0 + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.x1, (double)(this.y1 - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.x0, (double)(this.y1 - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int maxScroll = Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
            if (maxScroll > 0) {
                int scrollBarStartY = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                scrollBarStartY = MathHelper.func_76125_a((int)scrollBarStartY, (int)32, (int)(this.y1 - this.y0 - 8));
                int scrollBarEndY = (int)this.getScrollAmount() * (this.y1 - this.y0 - scrollBarStartY) / maxScroll + this.y0;
                if (scrollBarEndY < this.y0) {
                    scrollBarEndY = this.y0;
                }
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_225582_a_((double)scrollBarStart, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)(scrollBarEndY + scrollBarStartY), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)(scrollBarEndY + scrollBarStartY), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)scrollBarEndY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)scrollBarEndY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)(scrollBarEndY + scrollBarStartY - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollBarEnd - 1), (double)(scrollBarEndY + scrollBarStartY - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollBarEnd - 1), (double)scrollBarEndY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)scrollBarEndY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.renderToolTips(mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ConfigEntry<T extends ForgeConfigSpec.ConfigValue>
    extends Entry {
        protected T configValue;
        protected ForgeConfigSpec.ValueSpec valueSpec;
        protected final List<IGuiEventListener> eventListeners;
        protected Button resetButton;
        final /* synthetic */ ConfigScreen this$0;

        public ConfigEntry(T configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.this$0 = this$0;
            super(ConfigScreen.createLabelFromConfig(configValue, valueSpec));
            this.eventListeners = Lists.newArrayList();
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            if (valueSpec.getComment() != null) {
                this.tooltip = this.createToolTip((ForgeConfigSpec.ConfigValue<?>)configValue, valueSpec);
            }
            IconButton.Tooltip tooltip = (button, mouseX, mouseY) -> {
                if (button.active && button.isHovered()) {
                    this.this$0.renderTooltip(((ConfigScreen)this.this$0).minecraft.field_71466_p.func_78271_c(new TranslationTextComponent("configured.gui.reset", new Object[0]).func_150254_d(), Math.max(this.this$0.width / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            this.resetButton = new IconButton(0, 0, 20, 20, 0, 0, tooltip, onPress -> {
                configValue.set(valueSpec.getDefault());
                this.onResetValue();
            });
            this.eventListeners.add((IGuiEventListener)this.resetButton);
        }

        public void onResetValue() {
        }

        public List<? extends IGuiEventListener> children() {
            return this.eventListeners;
        }

        public void render(int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.resetButton.active = !this.configValue.get().equals(this.valueSpec.getDefault());
            StringTextComponent title = new StringTextComponent(this.label);
            if (((ConfigScreen)this.this$0).minecraft.field_71466_p.func_78256_a(title.func_150261_e()) > width - 75) {
                String trimmed = ((ConfigScreen)this.this$0).minecraft.field_71466_p.func_78269_a(title.func_150254_d(), width - 75).trim() + "...";
                ((ConfigScreen)this.this$0).minecraft.field_71466_p.func_175063_a(new StringTextComponent(trimmed).func_150265_g(), (float)left, (float)(top + 6), 0xFFFFFF);
            } else {
                ((ConfigScreen)this.this$0).minecraft.field_71466_p.func_175063_a(title.func_150254_d(), (float)left, (float)(top + 6), 0xFFFFFF);
            }
            if (this.isMouseOver(mouseX, mouseY) && mouseX < this.this$0.list.getRowLeft() + this.this$0.list.getRowWidth() - 67) {
                this.this$0.setActiveTooltip(this.tooltip);
            }
            this.resetButton.x = left + width - 21;
            this.resetButton.y = top;
            this.resetButton.render(mouseX, mouseY, partialTicks);
        }

        private List<String> createToolTip(ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
            int i;
            FontRenderer font = ((ConfigScreen)this.this$0).minecraft.field_71466_p;
            ArrayList<String> lines = new ArrayList<String>(font.func_78271_c(new StringTextComponent(spec.getComment()).func_150265_g(), 200));
            String name = (String)ConfigScreen.lastValue(value.getPath(), "");
            lines.add(0, new StringTextComponent(name).func_211708_a(TextFormatting.YELLOW).func_150254_d());
            int rangeIndex = -1;
            for (i = 0; i < lines.size(); ++i) {
                String text = (String)lines.get(i);
                if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                rangeIndex = i;
                break;
            }
            if (rangeIndex != -1) {
                for (i = rangeIndex; i < lines.size(); ++i) {
                    lines.set(i, new StringTextComponent((String)lines.get(i)).func_211708_a(TextFormatting.GRAY).func_150254_d());
                }
            }
            return lines;
        }
    }

    public class SubMenu
    extends Entry {
        private final Button button;

        public SubMenu(String label, ForgeConfigSpec spec, AbstractConfig values) {
            super(ConfigScreen.createLabel(label));
            this.button = new Button(10, 5, 44, 20, new StringTextComponent(this.getLabel()).func_211708_a(TextFormatting.BOLD).func_211708_a(TextFormatting.WHITE).func_150254_d(), onPress -> {
                String newTitle = ConfigScreen.this.displayName + " > " + this.getLabel();
                ConfigScreen.this.minecraft.func_147108_a((Screen)new ConfigScreen((Screen)ConfigScreen.this, newTitle, spec, (UnmodifiableConfig)values, ConfigScreen.this.background));
            });
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.button);
        }

        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.x = left - 1;
            this.button.y = top;
            this.button.setWidth(width);
            this.button.render(mouseX, mouseY, partialTicks);
        }
    }

    public class TitleEntry
    extends Entry {
        public TitleEntry(String title) {
            super(title);
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }

        public void render(int x, int top, int left, int width, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ITextComponent title = new StringTextComponent(this.label).func_211708_a(TextFormatting.BOLD).func_211708_a(TextFormatting.YELLOW);
            ConfigScreen.this.drawCenteredString(((ConfigScreen)ConfigScreen.this).minecraft.field_71466_p, title.func_150254_d(), left + width / 2, top + 5, 0xFFFFFF);
        }
    }

    abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        protected String label;
        protected List<String> tooltip;

        public Entry(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

