/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class EditStringListScreen
extends Screen {
    private final Screen parent;
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final ForgeConfigSpec.ConfigValue<List<?>> listValue;
    private final ForgeConfigSpec.ValueSpec valueSpec;
    private StringList list;

    public EditStringListScreen(Screen parent, ITextComponent titleIn, ForgeConfigSpec.ConfigValue<List<?>> listValue, ForgeConfigSpec.ValueSpec valueSpec) {
        super(titleIn);
        this.parent = parent;
        this.listValue = listValue;
        this.valueSpec = valueSpec;
        this.values.addAll(((List)listValue.get()).stream().map(o -> new StringHolder(o.toString())).collect(Collectors.toList()));
    }

    protected void init() {
        this.list = new StringList();
        this.children.add(this.list);
        this.addButton((Widget)new Button(this.width / 2 - 140, this.height - 29, 90, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            List newValues = this.values.stream().map(StringHolder::getValue).collect(Collectors.toList());
            this.valueSpec.correct(newValues);
            this.listValue.set(newValues);
            this.minecraft.func_147108_a(this.parent);
        }));
        this.addButton((Widget)new Button(this.width / 2 - 45, this.height - 29, 90, 20, I18n.func_135052_a((String)"configured.gui.add_value", (Object[])new Object[0]), button -> this.minecraft.func_147108_a((Screen)new EditStringScreen(this, (ITextComponent)new TranslationTextComponent("configured.gui.edit_value", new Object[0]), "", o -> true, s -> {
            StringHolder holder = new StringHolder((String)s);
            this.values.add(holder);
            this.list.addEntry(new StringEntry(this.list, holder));
        }))));
        this.addButton((Widget)new Button(this.width / 2 + 50, this.height - 29, 90, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.minecraft.func_147108_a(this.parent)));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.list.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 14, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringEntry
    extends AbstractOptionList.Entry<StringEntry> {
        private StringHolder holder;
        private final StringList list;
        private final Button editButton;
        private final Button deleteButton;

        public StringEntry(StringList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new Button(0, 0, 42, 20, new StringTextComponent("Edit").func_150265_g(), onPress -> EditStringListScreen.this.minecraft.func_147108_a((Screen)new EditStringScreen(EditStringListScreen.this, (ITextComponent)new TranslationTextComponent("configured.gui.edit_value", new Object[0]), this.holder.getValue(), o -> true, s -> this.holder.setValue((String)s))));
            IconButton.Tooltip tooltip = (button, mouseX, mouseY) -> {
                if (button.active && button.isHovered()) {
                    EditStringListScreen.this.renderTooltip(((EditStringListScreen)EditStringListScreen.this).minecraft.field_71466_p.func_78271_c(I18n.func_135052_a((String)"configured.gui.remove", (Object[])new Object[0]), Math.max(EditStringListScreen.this.width / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            this.deleteButton = new IconButton(0, 0, 20, 20, 11, 0, tooltip, onPress -> {
                EditStringListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            });
        }

        public void render(int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((EditStringListScreen)EditStringListScreen.this).minecraft.field_71466_p.func_211126_b(new StringTextComponent(this.holder.getValue()).func_150265_g(), (float)(left + 5), (float)(top + 6), 0xFFFFFF);
            this.editButton.visible = true;
            this.editButton.x = left + width - 65;
            this.editButton.y = top;
            this.editButton.render(mouseX, mouseY, partialTicks);
            this.deleteButton.visible = true;
            this.deleteButton.x = left + width - 21;
            this.deleteButton.y = top;
            this.deleteButton.render(mouseX, mouseY, partialTicks);
        }

        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.editButton, (Object)this.deleteButton);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class StringList
    extends ExtendedList<StringEntry> {
        public StringList() {
            super(EditStringListScreen.this.minecraft, EditStringListScreen.this.width, EditStringListScreen.this.height, 36, EditStringListScreen.this.height - 36, 24);
            EditStringListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 144;
        }

        public int getRowWidth() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.addEntry((AbstractList.AbstractListEntry)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.removeEntry((AbstractList.AbstractListEntry)entry);
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            super.render(mouseX, mouseY, partialTicks);
            this.children().forEach(entry -> entry.children().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).renderToolTip(mouseX, mouseY);
                }
            }));
        }
    }
}

