/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class EditListScreen
extends Screen
implements IBackgroundTexture {
    private static final Map<ForgeConfigSpec.ConfigValue<?>, ListType> TYPE_CACHE = new HashMap();
    private final Screen parent;
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final ForgeConfigSpec.ValueSpec valueSpec;
    private final ResourceLocation background;
    private final ConfigScreen.ListValueHolder holder;
    private final ListType listType;
    private ObjectList list;

    public EditListScreen(Screen parent, Component titleIn, ConfigScreen.ListValueHolder holder, ResourceLocation background) {
        super(titleIn);
        this.parent = parent;
        this.holder = holder;
        this.valueSpec = holder.getSpec();
        this.listType = EditListScreen.getType(holder);
        this.values.addAll(((List)holder.getValue()).stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).collect(Collectors.toList()));
        this.background = background;
    }

    protected void m_7856_() {
        this.list = new ObjectList();
        this.list.m_93488_(!ListMenuScreen.isPlayingGame());
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 140, this.f_96544_ - 29, 90, 20, CommonComponents.f_130655_, button -> {
            List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
            this.valueSpec.correct(newValues);
            this.holder.setValue(newValues);
            this.f_96541_.m_91152_(this.parent);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 45, this.f_96544_ - 29, 90, 20, (Component)new TranslatableComponent("configured.gui.add_value"), button -> this.f_96541_.m_91152_((Screen)new EditStringScreen(this, this.background, (Component)new TranslatableComponent("configured.gui.edit_value"), "", s -> {
            Object value = this.listType.getValueParser().apply((String)s);
            return value != null && this.valueSpec.test(Collections.singletonList(value));
        }, s -> {
            StringHolder holder = new StringHolder((String)s);
            this.values.add(holder);
            this.list.addEntry(new StringEntry(this.list, holder));
        }))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 50, this.f_96544_ - 29, 90, 20, CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        EditListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)14, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    protected static ListType getType(ConfigScreen.ListValueHolder holder) {
        return TYPE_CACHE.computeIfAbsent(holder.getConfigValue(), value -> ListType.fromHolder(holder));
    }

    protected static enum ListType {
        BOOLEAN(Object::toString, Boolean::valueOf),
        INTEGER(Object::toString, Ints::tryParse),
        LONG(Object::toString, Longs::tryParse),
        DOUBLE(Object::toString, Doubles::tryParse),
        STRING(Object::toString, o -> o),
        UNKNOWN(Object::toString, o -> o);

        final Function<Object, String> stringParser;
        final Function<String, ?> valueParser;

        private ListType(Function<Object, String> stringParser, Function<String, ?> valueParser) {
            this.stringParser = stringParser;
            this.valueParser = valueParser;
        }

        public Function<Object, String> getStringParser() {
            return this.stringParser;
        }

        public Function<String, ?> getValueParser() {
            return this.valueParser;
        }

        protected static ListType fromHolder(ConfigScreen.ListValueHolder holder) {
            ListType type = UNKNOWN;
            List defaultList = (List)holder.getSpec().getDefault();
            if (!defaultList.isEmpty()) {
                type = ListType.fromObject(defaultList.get(0));
            }
            if (type == UNKNOWN) {
                type = ListType.fromList((List)holder.getValue());
            }
            if (type == UNKNOWN) {
                type = ListType.fromElementValidator(holder.getSpec());
            }
            return type;
        }

        protected static ListType fromObject(Object o) {
            if (o instanceof Boolean) {
                return BOOLEAN;
            }
            if (o instanceof Integer) {
                return INTEGER;
            }
            if (o instanceof Long) {
                return LONG;
            }
            if (o instanceof Double) {
                return DOUBLE;
            }
            if (o instanceof String) {
                return STRING;
            }
            return UNKNOWN;
        }

        protected static ListType fromList(List<?> list) {
            if (!list.isEmpty()) {
                return ListType.fromObject(list.get(0));
            }
            return ListType.fromListAdd(list);
        }

        private static ListType fromElementValidator(ForgeConfigSpec.ValueSpec spec) {
            if (spec.test(Collections.singletonList("s"))) {
                return STRING;
            }
            if (spec.test(Collections.singletonList(true))) {
                return BOOLEAN;
            }
            if (spec.test(Collections.singletonList(0.0))) {
                return DOUBLE;
            }
            if (spec.test(Collections.singletonList(0L))) {
                return LONG;
            }
            if (spec.test(Collections.singletonList(0))) {
                return INTEGER;
            }
            return UNKNOWN;
        }

        private static ListType fromListAdd(List<?> list) {
            if (!list.isEmpty()) {
                return ListType.fromObject(list.get(0));
            }
            if (ListType.testAddValue(list, Boolean.TRUE)) {
                return BOOLEAN;
            }
            if (ListType.testAddValue(list, "s")) {
                return STRING;
            }
            if (ListType.testAddValue(list, Double.MAX_VALUE)) {
                return DOUBLE;
            }
            if (ListType.testAddValue(list, Long.MAX_VALUE)) {
                return LONG;
            }
            if (ListType.testAddValue(list, Integer.MAX_VALUE)) {
                return INTEGER;
            }
            return UNKNOWN;
        }

        private static boolean testAddValue(List list, Object v) {
            try {
                list.add(v);
                list.clear();
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ObjectList
    extends ContainerObjectSelectionList<StringEntry>
    implements IBackgroundTexture {
        public ObjectList() {
            super(EditListScreen.this.f_96541_, EditListScreen.this.f_96543_, EditListScreen.this.f_96544_, 36, EditListScreen.this.f_96544_ - 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.m_93502_((AbstractSelectionList.Entry)entry);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.m_6702_().forEach(entry -> entry.m_6702_().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).m_7428_(poseStack, mouseX, mouseY);
                }
            }));
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return EditListScreen.this.background;
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringEntry
    extends ContainerObjectSelectionList.Entry<StringEntry> {
        private StringHolder holder;
        private final ObjectList list;
        private final Button editButton;
        private final Button deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new Button(0, 0, 42, 20, (Component)new TextComponent("Edit"), onPress -> EditListScreen.this.f_96541_.m_91152_((Screen)new EditStringScreen(EditListScreen.this, EditListScreen.this.background, (Component)new TranslatableComponent("configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                return value != null && EditListScreen.this.valueSpec.test(Collections.singletonList(value));
            }, s -> this.holder.setValue((String)s))));
            Button.OnTooltip tooltip = (button, matrixStack, mouseX, mouseY) -> {
                if (button.f_93623_ && button.m_5702_()) {
                    EditListScreen.this.m_96617_(matrixStack, ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("configured.gui.remove"), Math.max(EditListScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            }, tooltip);
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92889_(poseStack, (Component)new TextComponent(this.holder.getValue()), (float)(left + 5), (float)(top + 6), 0xFFFFFF);
            this.editButton.f_93624_ = true;
            this.editButton.f_93620_ = left + width - 65;
            this.editButton.f_93621_ = top;
            this.editButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.f_93624_ = true;
            this.deleteButton.f_93620_ = left + width - 21;
            this.deleteButton.f_93621_ = top;
            this.deleteButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.editButton, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169143_(NarratedElementType.TITLE, StringEntry.this.holder.getValue());
                }
            }, (Object)this.editButton, (Object)this.deleteButton);
        }
    }
}

