/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends ListMenuScreen {
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final FolderEntry folderEntry;
    protected ModConfig config;
    protected Button saveButton;
    protected Button restoreButton;

    private ConfigScreen(Screen parent, ITextComponent title, ResourceLocation background, FolderEntry folderEntry) {
        super(parent, title, background, 24);
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(Screen parent, ITextComponent title, ModConfig config, ResourceLocation background) {
        super(parent, title, background, 24);
        this.folderEntry = new FolderEntry("Root", config.getSpec().getValues(), config.getSpec(), true);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getEntries().forEach(c -> {
            if (c instanceof FolderEntry) {
                configEntries.add(new FolderItem((FolderEntry)c));
            } else if (c instanceof ValueEntry) {
                ValueEntry configValueEntry = (ValueEntry)c;
                Object value = ((ValueEntry)c).getHolder().getValue();
                if (value instanceof Boolean) {
                    configEntries.add(new BooleanItem(configValueEntry.getHolder()));
                } else if (value instanceof Integer) {
                    configEntries.add(new IntegerItem(configValueEntry.getHolder()));
                } else if (value instanceof Double) {
                    configEntries.add(new DoubleItem(configValueEntry.getHolder()));
                } else if (value instanceof Long) {
                    configEntries.add(new LongItem(configValueEntry.getHolder()));
                } else if (value instanceof Enum) {
                    configEntries.add(new EnumItem(configValueEntry.getHolder()));
                } else if (value instanceof String) {
                    configEntries.add(new StringItem(configValueEntry.getHolder()));
                } else if (value instanceof List) {
                    configEntries.add(new ListItem((ListValueHolder)configValueEntry.getHolder()));
                } else {
                    Configured.LOGGER.info("Unsupported config value: " + ((ValueHolder)configValueEntry.getHolder()).configValue.getPath());
                }
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_230708_k_ / 2 - 140, this.field_230709_l_ - 29, 22, 0, 90, (ITextComponent)new TranslationTextComponent("configured.gui.save"), button -> {
                if (this.config != null) {
                    this.saveConfig();
                }
                this.field_230706_i_.func_147108_a(this.parent);
            }));
            this.restoreButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_230708_k_ / 2 - 45, this.field_230709_l_ - 29, 0, 0, 90, (ITextComponent)new TranslationTextComponent("configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 50, this.field_230709_l_ - 29, 90, 20, DialogTexts.field_240633_d_, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmationScreen(this, (ITextComponent)new TranslationTextComponent("configured.gui.unsaved_changes"), result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.field_230706_i_.func_147108_a(this.parent);
                        return false;
                    }));
                } else {
                    this.field_230706_i_.func_147108_a(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
        }
    }

    private void saveConfig() {
        if (!this.isChanged(this.folderEntry)) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        ArrayDeque<FolderEntry> found = new ArrayDeque<FolderEntry>();
        found.add(this.folderEntry);
        while (!found.isEmpty()) {
            FolderEntry folder = (FolderEntry)found.poll();
            for (IEntry entry : folder.getEntries()) {
                ListValueHolder listHolder;
                Function<List<?>, List<?>> converter;
                ValueEntry valueEntry;
                ValueHolder<?> holder;
                if (entry instanceof FolderEntry) {
                    found.offer((FolderEntry)entry);
                    continue;
                }
                if (!(entry instanceof ValueEntry) || !(holder = (valueEntry = (ValueEntry)entry).getHolder()).isChanged()) continue;
                List path = ((ValueHolder)holder).configValue.getPath();
                if (holder instanceof ListValueHolder && (converter = (listHolder = (ListValueHolder)holder).getConverter()) != null) {
                    List<?> convertedList = converter.apply((List<?>)listHolder.getValue());
                    newConfig.set(path, convertedList);
                    continue;
                }
                newConfig.set(path, holder.getValue());
            }
        }
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        if (this.config.getType() == ModConfig.Type.SERVER) {
            if (!ListMenuScreen.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ConfigHelper.setConfigData(this.config, null);
            } else {
                ConfigHelper.sendConfigDataToServer(this.config);
            }
        } else {
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            ConfigHelper.fireEvent(this.config, (ModConfig.ModConfigEvent)ConfigHelper.reloadingEvent(this.config));
        }
    }

    private void showRestoreScreen() {
        ConfirmationScreen confirmScreen = new ConfirmationScreen(this, (ITextComponent)new TranslationTextComponent("configured.gui.restore_message"), result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setBackground(this.background);
        confirmScreen.setPositiveText((ITextComponent)new TranslationTextComponent("configured.gui.reset_all").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD}));
        confirmScreen.setNegativeText(DialogTexts.field_240633_d_);
        Minecraft.func_71410_x().func_147108_a((Screen)confirmScreen);
    }

    private void restoreDefaults(FolderEntry entry) {
        entry.getEntries().forEach(e -> {
            if (e instanceof FolderEntry) {
                this.restoreDefaults((FolderEntry)e);
            } else if (e instanceof ValueEntry) {
                ((ValueEntry)e).getHolder().restoreDefaultValue();
            }
        });
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                this.saveButton.field_230693_o_ = this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.field_230693_o_ = this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ConfigScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    private static String createLabelFromHolder(ValueHolder<?> holder) {
        if (((ValueHolder)holder).valueSpec.getTranslationKey() != null && I18n.func_188566_a((String)((ValueHolder)holder).valueSpec.getTranslationKey())) {
            return new TranslationTextComponent(((ValueHolder)holder).valueSpec.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(ConfigScreen.lastValue(((ValueHolder)holder).configValue.getPath(), ""));
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public boolean func_231178_ax__() {
        return this.config == null || this.config.getType() != ModConfig.Type.SERVER;
    }

    public boolean isModified(FolderEntry folder) {
        for (IEntry entry : folder.getEntries()) {
            if (!(entry instanceof FolderEntry ? this.isModified((FolderEntry)entry) : entry instanceof ValueEntry && !((ValueEntry)entry).getHolder().isDefaultValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(FolderEntry folder) {
        for (IEntry entry : folder.getEntries()) {
            if (!(entry instanceof FolderEntry ? this.isChanged((FolderEntry)entry) : entry instanceof ValueEntry && ((ValueEntry)entry).getHolder().isChanged())) continue;
            return true;
        }
        return false;
    }

    public class ValueEntry
    implements IEntry {
        private final ValueHolder<?> holder;

        public ValueEntry(ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.holder = configValue.get() instanceof List ? new ListValueHolder((ForgeConfigSpec.ConfigValue<List<?>>)configValue, valueSpec) : new ValueHolder(configValue, valueSpec);
        }

        public ValueHolder<?> getHolder() {
            return this.holder;
        }
    }

    public class FolderEntry
    implements IEntry {
        private final String label;
        private final UnmodifiableConfig config;
        private final ForgeConfigSpec spec;
        private final boolean root;
        private List<IEntry> entries;

        public FolderEntry(String label, UnmodifiableConfig config, ForgeConfigSpec spec, boolean root) {
            this.label = label;
            this.config = config;
            this.spec = spec;
            this.root = root;
            this.init();
        }

        private void init() {
            if (this.entries == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.config.valueMap().forEach((s, o) -> {
                    if (o instanceof UnmodifiableConfig) {
                        builder.add((Object)new FolderEntry((String)s, (UnmodifiableConfig)o, this.spec, false));
                    } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                        ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                        builder.add((Object)new ValueEntry(configValue, valueSpec));
                    }
                });
                this.entries = builder.build();
            }
        }

        public boolean isRoot() {
            return this.root;
        }

        public boolean isInitialized() {
            return this.entries != null;
        }

        public List<IEntry> getEntries() {
            return this.entries;
        }
    }

    public static interface IEntry {
    }

    public class ListValueHolder
    extends ValueHolder<List<?>> {
        @Nullable
        private final Function<List<?>, List<?>> converter;

        public ListValueHolder(ForgeConfigSpec.ConfigValue<List<?>> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(configValue, valueSpec);
            this.converter = this.createConverter(configValue);
        }

        @Nullable
        private Function<List<?>, List<?>> createConverter(ForgeConfigSpec.ConfigValue<List<?>> configValue) {
            List original = (List)configValue.get();
            if (original instanceof ArrayList) {
                return ArrayList::new;
            }
            if (original instanceof LinkedList) {
                return LinkedList::new;
            }
            return null;
        }

        @Override
        protected void setValue(List<?> value) {
            this.value = new ArrayList(value);
        }

        @Nullable
        public Function<List<?>, List<?>> getConverter() {
            return this.converter;
        }
    }

    public class ValueHolder<T> {
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private final T initialValue;
        protected T value;

        public ValueHolder(ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            this.initialValue = configValue.get();
            this.setValue(configValue.get());
        }

        protected void setValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void restoreDefaultValue() {
            this.setValue(this.valueSpec.getDefault());
            ConfigScreen.this.updateButtons();
        }

        public boolean isDefaultValue() {
            return this.value.equals(this.valueSpec.getDefault());
        }

        public boolean isChanged() {
            return !this.value.equals(this.initialValue);
        }

        public ForgeConfigSpec.ConfigValue<T> getConfigValue() {
            return this.configValue;
        }

        public ForgeConfigSpec.ValueSpec getSpec() {
            return this.valueSpec;
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final Button button;

        public EnumItem(ValueHolder<Enum<?>> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (ITextComponent)new TranslationTextComponent("configured.gui.change"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new ChangeEnumScreen(ConfigScreen.this, this.label, ConfigScreen.this.background, (Enum)holder.getValue(), e -> {
                holder.setValue((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 69;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final Button button;

        public ListItem(ListValueHolder holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (ITextComponent)new TranslationTextComponent("configured.gui.edit"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new EditListScreen(ConfigScreen.this, this.label, holder, ConfigScreen.this.background)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 69;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final Button button;

        public StringItem(ValueHolder<String> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (ITextComponent)new TranslationTextComponent("configured.gui.edit"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.background, this.label, (String)holder.getValue(), arg_0 -> ((ForgeConfigSpec.ValueSpec)((ValueHolder)holder).valueSpec).test(arg_0), s -> {
                holder.setValue((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 69;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final Button button;

        public BooleanItem(ValueHolder<Boolean> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, DialogTexts.func_240638_a_((boolean)holder.getValue()), button -> {
                holder.setValue((Boolean)holder.getValue() == false);
                button.func_238482_a_(DialogTexts.func_240638_a_((boolean)((Boolean)holder.getValue())));
                ConfigScreen.this.updateButtons();
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 69;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.func_238482_a_(DialogTexts.func_240638_a_((boolean)((Boolean)this.holder.getValue())));
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(ValueHolder<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(ValueHolder<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(ValueHolder<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedTextFieldWidget textField;

        public NumberItem(ValueHolder<T> holder, Function<String, Number> parser) {
            super(holder);
            this.textField = new ListMenuScreen.FocusedTextFieldWidget(ConfigScreen.this, ConfigScreen.this.field_230712_o_, 0, 0, 44, 18, this.label);
            this.textField.func_146180_a(((Number)holder.getValue()).toString());
            this.textField.func_212954_a(s -> {
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (((ValueHolder)holder).valueSpec.test((Object)n)) {
                        this.textField.func_146193_g(0xE0E0E0);
                        holder.setValue(n);
                        ConfigScreen.this.updateButtons();
                    } else {
                        this.textField.func_146193_g(0xFF0000);
                    }
                }
                catch (Exception ignored) {
                    this.textField.func_146193_g(0xFF0000);
                }
            });
            this.eventListeners.add(this.textField);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.textField.field_230690_l_ = left + width - 68;
            this.textField.field_230691_m_ = top + 1;
            this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.func_146180_a(((Number)this.holder.getValue()).toString());
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final ValueHolder<T> holder;
        protected final List<IGuiEventListener> eventListeners;
        protected final Button resetButton;

        public ConfigItem(ValueHolder<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = Lists.newArrayList();
            this.holder = holder;
            if (((ValueHolder)this.holder).valueSpec.getComment() != null) {
                this.tooltip = this.createToolTip(holder);
            }
            int maxTooltipWidth = Math.max(ConfigScreen.this.field_230708_k_ / 2 - 43, 170);
            Button.ITooltip tooltip = ScreenUtil.createButtonTooltip(ConfigScreen.this, (ITextComponent)new TranslationTextComponent("configured.gui.reset"), maxTooltipWidth);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restoreDefaultValue();
                this.onResetValue();
            }, tooltip);
            this.eventListeners.add((IGuiEventListener)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.eventListeners;
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Minecraft.func_71410_x().field_71466_p.func_243246_a(matrixStack, this.getTrimmedLabel(width - 75), (float)left, (float)(top + 6), 0xFFFFFF);
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.func_230968_n_() + ConfigScreen.this.list.func_230949_c_() - 67) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
            this.resetButton.field_230693_o_ = !this.holder.isDefaultValue();
            this.resetButton.field_230690_l_ = left + width - 21;
            this.resetButton.field_230691_m_ = top;
            this.resetButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        private ITextComponent getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)this.label) > maxWidth) {
                return new StringTextComponent(((ConfigScreen)ConfigScreen.this).field_230706_i_.field_71466_p.func_238417_a_((ITextProperties)this.label, maxWidth).getString() + "...");
            }
            return this.label;
        }

        private List<IReorderingProcessor> createToolTip(ValueHolder<T> holder) {
            int i;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            List lines = font.func_238420_b_().func_238362_b_((ITextProperties)new StringTextComponent(((ValueHolder)holder).valueSpec.getComment()), 200, Style.field_240709_b_);
            String name = (String)ConfigScreen.lastValue(((ValueHolder)holder).configValue.getPath(), "");
            lines.add(0, new StringTextComponent(name).func_240699_a_(TextFormatting.YELLOW));
            int rangeIndex = -1;
            for (i = 0; i < lines.size(); ++i) {
                String text = ((ITextProperties)lines.get(i)).getString();
                if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                rangeIndex = i;
                break;
            }
            if (rangeIndex != -1) {
                for (i = rangeIndex; i < lines.size(); ++i) {
                    lines.set(i, new StringTextComponent(((ITextProperties)lines.get(i)).getString()).func_240699_a_(TextFormatting.GRAY));
                }
            }
            return LanguageMap.func_74808_a().func_244260_a(lines);
        }
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final Button button;

        public FolderItem(FolderEntry folderEntry) {
            super((ListMenuScreen)ConfigScreen.this, (ITextComponent)new StringTextComponent(ConfigScreen.createLabel(folderEntry.label)));
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new StringTextComponent(this.getLabel()).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.WHITE), onPress -> {
                IFormattableTextComponent newTitle = ConfigScreen.this.field_230704_d_.func_230531_f_().func_240702_b_(" > " + this.getLabel());
                ConfigScreen.this.field_230706_i_.func_147108_a((Screen)new ConfigScreen(ConfigScreen.this, (ITextComponent)newTitle, ConfigScreen.this.background, folderEntry));
            });
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.button);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_230690_l_ = left - 1;
            this.button.field_230691_m_ = top;
            this.button.func_230991_b_(width);
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }
}

