/*
 * Decompiled with CFR 0.152.
 */
package frakier.cowboyup.worker;

import frakier.cowboyup.CowboyUp;
import frakier.cowboyup.config.CowboyUpConfig;
import frakier.cowboyup.init.KeyBindings;
import frakier.cowboyup.worker.HorseStays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LeashReturn {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        if (CowboyUp.debug) {
            LOGGER.info("LeashReturn init");
        }
        LeashReturn.status();
    }

    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        if (LeashReturn.mc.field_71439_g != null && event.getTarget() instanceof AnimalEntity && leashReturn.booleanValue()) {
            if (event.getHand().equals((Object)Hand.MAIN_HAND)) {
                if (CowboyUp.debug) {
                    LOGGER.info("LeashReturn onInteract main hand");
                }
                LeashReturn.leash(Hand.MAIN_HAND, event);
            }
            if (event.getHand().equals((Object)Hand.OFF_HAND)) {
                if (CowboyUp.debug) {
                    LOGGER.info("LeashReturn onInteract off hand");
                }
                LeashReturn.leash(Hand.OFF_HAND, event);
            }
        }
    }

    private static void leash(Hand hand, PlayerInteractEvent.EntityInteract event) {
        Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        ItemStack heldItem = event.getPlayer().func_184586_b(hand);
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        boolean leashed = ((AnimalEntity)target).func_110167_bD();
        Entity leashholder = ((AnimalEntity)target).func_110166_bE();
        if (leashReturn.booleanValue()) {
            if (leashed && leashholder != null && LeashReturn.mc.field_71441_e != null) {
                if (CowboyUp.debug) {
                    LOGGER.info("remove leash " + hand.name());
                }
                ((AnimalEntity)target).func_110160_i(true, false);
                int i = LeashReturn.getFirstInventorySlotsWithAvailableSpace(player, new ItemStack((IItemProvider)Items.field_151058_ca, 1));
                if (i != -1) {
                    player.field_71071_by.func_70301_a(i).func_190917_f(1);
                } else {
                    int j = player.field_71071_by.func_70447_i();
                    if (j != -1) {
                        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151058_ca, 1));
                    } else {
                        player.func_71019_a(new ItemStack((IItemProvider)Items.field_151058_ca, 1), false);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            } else if (heldItem.func_77973_b().equals(Items.field_151058_ca)) {
                if (CowboyUp.debug) {
                    LOGGER.info("add leash " + hand.name());
                }
                ((AnimalEntity)target).func_110162_b((Entity)player, true);
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    player.field_71071_by.func_184437_d(heldItem);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
        if (target.getEntity().func_200600_R() == EntityType.field_200762_B || target.getEntity().func_200600_R() == EntityType.field_200798_l || target.getEntity().func_200600_R() == EntityType.field_200779_S) {
            HorseStays.stayCmd(leashed, (AbstractHorseEntity)target);
        }
    }

    private static int getFirstInventorySlotsWithAvailableSpace(PlayerEntity player, ItemStack itemStack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            boolean empty = ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b();
            boolean equals = ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77969_a(itemStack);
            int count = ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190916_E();
            int max = ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77976_d();
            if (empty || !equals || count >= max) continue;
            return i;
        }
        return -1;
    }

    public static void onKeyInput() {
        Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        if (KeyBindings.KEYBINDINGS[2].func_151470_d()) {
            if (leashReturn.booleanValue() == LeashReturnCommand.ENABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.leashReturns.set((Object)LeashReturnCommand.DISABLED.getBooleanCode());
            } else if (leashReturn.booleanValue() == LeashReturnCommand.DISABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.leashReturns.set((Object)LeashReturnCommand.ENABLED.getBooleanCode());
            }
            LeashReturn.status();
        }
    }

    private static void status() {
        if (((Boolean)CowboyUpConfig.COMMON.reportStatus.get()).booleanValue() && Minecraft.func_71410_x().func_195544_aj() && !Minecraft.func_71410_x().func_147113_T()) {
            Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
            String m = TextFormatting.DARK_AQUA + "[" + TextFormatting.YELLOW + "CowboyUp" + TextFormatting.DARK_AQUA + "] ";
            m = leashReturn.booleanValue() == LeashReturnCommand.DISABLED.getBooleanCode() ? m + TextFormatting.RED + I18n.func_135052_a((String)LeashReturnCommand.DISABLED.getDesc(), (Object[])new Object[0]) : m + TextFormatting.GREEN + I18n.func_135052_a((String)LeashReturnCommand.ENABLED.getDesc(), (Object[])new Object[0]);
            if (LeashReturn.mc.field_71439_g != null) {
                LeashReturn.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(m), Util.field_240973_b_);
            }
        }
    }

    public static enum LeashReturnCommand {
        DISABLED(0, "msg.cowboyup.LeashReturns.disabled"),
        ENABLED(1, "msg.cowboyup.LeashReturns.enabled");

        private final int levelCode;
        private final String desc;

        private LeashReturnCommand(int levelCode, String desc) {
            this.levelCode = levelCode;
            this.desc = desc;
        }

        public boolean getBooleanCode() {
            return this.levelCode != 0;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

