/*
 * Decompiled with CFR 0.152.
 */
package frakier.cowboyup.worker;

import frakier.cowboyup.CowboyUp;
import frakier.cowboyup.config.CowboyUpConfig;
import frakier.cowboyup.init.KeyBindings;
import frakier.cowboyup.worker.helper.HorseWorkerHelpers;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorseSwim {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Logger LOGGER = LogManager.getLogger();
    static BlockPos FeetWetPos = new BlockPos(0, 0, 0);
    static Boolean swimmingWithPlayer = false;
    private static boolean falling = false;
    private static double swimTimer = 0.0;
    private static int swimTicks = 0;
    private static Integer swimTime = 0;
    private static boolean swimTimerChanged;

    public static void init() {
        if (CowboyUp.debug) {
            LOGGER.info("HorseSwim init");
        }
        HorseSwim.status();
    }

    public static void TickEvent(TickEvent.PlayerTickEvent event) {
        Boolean horseSwimsWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
        swimTime = (Integer)CowboyUpConfig.COMMON.swimTime.get();
        AbstractHorse horse = (AbstractHorse)event.player.m_20202_();
        if (horseSwimsWithRider.booleanValue() && HorseSwim.mc.f_91073_ != null && horse != null) {
            boolean jumping;
            boolean watersEdge;
            BlockPos underHorseBlock = horse.m_20097_().m_142082_(0, -1, 0);
            boolean solidUnderHorse = HorseSwim.mc.f_91073_.m_8055_(underHorseBlock).m_60767_().m_76333_();
            boolean inFluid = HorseSwim.mc.f_91073_.m_8055_(horse.m_20097_()).m_60767_().m_76332_();
            boolean eyesInFluid = HorseWorkerHelpers.areEyesInAnyFuid((Entity)horse);
            if (CowboyUp.debug) {
                LOGGER.info("inFluid: " + inFluid + "eyesInFluid " + eyesInFluid);
            }
            Direction.Axis axis = horse.m_6350_().m_122434_();
            BlockPos nextStepBlock = horse.m_20097_().m_142629_(axis, 1);
            boolean nextStep = HorseSwim.mc.f_91073_.m_8055_(nextStepBlock).m_60767_().m_76333_();
            float moveSpeed = horse.m_6113_();
            if (CowboyUp.debug) {
                LOGGER.info("solidUnderHorse " + solidUnderHorse + " inFluid " + inFluid + " eyesInFluid " + eyesInFluid);
            }
            boolean dryLand = !inFluid && solidUnderHorse;
            boolean wading = inFluid && solidUnderHorse && !eyesInFluid;
            boolean swimming = inFluid && !solidUnderHorse && !eyesInFluid;
            boolean underWater = inFluid && eyesInFluid;
            boolean bl = watersEdge = inFluid && nextStep;
            if (CowboyUp.debug) {
                LOGGER.info("dryLand " + dryLand + " wading " + wading + " swimming " + swimming + " underWater " + underWater + " watersEdge " + watersEdge);
            }
            if (horse.f_19789_ > 4.0f) {
                falling = true;
            }
            if (underWater) {
                falling = false;
                if (horse.m_5807_()) {
                    // empty if block
                }
            }
            if (dryLand) {
                falling = false;
                swimmingWithPlayer = false;
                swimTimer = 0.0;
            }
            if (CowboyUp.debug) {
                LOGGER.info("dryLand " + dryLand + " wading " + wading + " swimming " + swimming + " underWater " + underWater + " watersEdge " + watersEdge + " falling " + falling);
            }
            if (CowboyUp.debug) {
                LOGGER.info("moveSpeed " + moveSpeed + " horse.getMotion(): " + horse.m_6374_().m_122429_() + ":" + horse.m_6374_().m_122431_() + ":" + horse.m_6374_().m_122430_());
            }
            if (!falling && !eyesInFluid) {
                if (CowboyUp.debug) {
                    LOGGER.info("moveSpeed " + moveSpeed + " swimming " + swimming + " wading" + wading);
                }
                if (swimming && swimTimer <= (double)swimTime.intValue()) {
                    double deepWaterVelocity = 0.9;
                    if (CowboyUp.debug) {
                        LOGGER.info("deepwater speed: " + deepWaterVelocity);
                    }
                    horse.m_20256_(horse.m_20184_().m_82542_(deepWaterVelocity, 0.0, deepWaterVelocity));
                    HorseSwim.advanceSwimTimer(horse);
                }
            }
            if (watersEdge && !(jumping = horse.m_30616_())) {
                horse.m_7023_(new Vec3((double)nextStepBlock.m_123341_(), (double)nextStepBlock.m_123342_(), (double)nextStepBlock.m_123343_()));
            }
        }
    }

    public static void advanceSwimTimer(AbstractHorse horse) {
        if (CowboyUp.debug) {
            LOGGER.info("swimming " + swimmingWithPlayer + " time left:" + swimTimer);
        }
        if (CowboyUp.debug) {
            LOGGER.info("time left:" + ((double)swimTime.intValue() - swimTimer));
        }
        if (!swimmingWithPlayer.booleanValue()) {
            swimmingWithPlayer = true;
            FeetWetPos = horse.m_20097_();
            swimTimer = 0.0;
        } else if (FeetWetPos.m_123333_((Vec3i)horse.m_20097_()) > 1 || swimTicks > 30) {
            FeetWetPos = horse.m_20097_();
            swimTimer += 1.0;
            swimTimerChanged = true;
            swimTicks = 0;
        } else {
            ++swimTicks;
        }
        if (swimTimerChanged) {
            swimTimerChanged = false;
        }
    }

    public static void onKeyInput() {
        Boolean horseSwimWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
        if (KeyBindings.KEYBINDINGS[0].m_90857_()) {
            if (horseSwimWithRider.booleanValue() == HorseSwimsWithRider.ENABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.horseCanSwimWithRider.set((Object)HorseSwimsWithRider.DISABLED.getBooleanCode());
            } else if (horseSwimWithRider.booleanValue() == HorseSwimsWithRider.DISABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.horseCanSwimWithRider.set((Object)HorseSwimsWithRider.ENABLED.getBooleanCode());
            }
            HorseSwim.status();
        }
    }

    private static void status() {
        if (((Boolean)CowboyUpConfig.COMMON.reportStatus.get()).booleanValue() && Minecraft.m_91087_().m_91302_() && !Minecraft.m_91087_().m_91104_()) {
            Boolean horseSwimWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
            String m = ChatFormatting.DARK_AQUA + "[" + ChatFormatting.YELLOW + "CowboyUp" + ChatFormatting.DARK_AQUA + "] ";
            m = horseSwimWithRider.booleanValue() == HorseSwimsWithRider.DISABLED.getBooleanCode() ? m + ChatFormatting.RED + I18n.m_118938_((String)HorseSwimsWithRider.DISABLED.getDesc(), (Object[])new Object[0]) : m + ChatFormatting.GREEN + I18n.m_118938_((String)HorseSwimsWithRider.ENABLED.getDesc(), (Object[])new Object[0]);
            if (HorseSwim.mc.f_91074_ != null) {
                HorseSwim.mc.f_91074_.m_6352_((Component)new TextComponent(m), Util.f_137441_);
            }
        }
    }

    public static enum HorseSwimsWithRider {
        DISABLED(0, "msg.cowboyup.HorseSwimsWithRider.disabled"),
        ENABLED(1, "msg.cowboyup.HorseSwimsWithRider.enabled");

        private final int levelCode;
        private final String desc;

        private HorseSwimsWithRider(int levelCode, String desc) {
            this.levelCode = levelCode;
            this.desc = desc;
        }

        public boolean getBooleanCode() {
            return this.levelCode != 0;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

