/*
 * Decompiled with CFR 0.152.
 */
package frakier.cowboyup.worker;

import frakier.cowboyup.CowboyUp;
import frakier.cowboyup.config.CowboyUpConfig;
import frakier.cowboyup.init.KeyBindings;
import frakier.cowboyup.worker.HorseStays;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LeashReturn {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        if (CowboyUp.debug) {
            LOGGER.info("LeashReturn init");
        }
        LeashReturn.status();
    }

    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        if (LeashReturn.mc.f_91074_ != null && event.getTarget() instanceof Animal) {
            if (event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
                if (CowboyUp.debug) {
                    LOGGER.info("LeashReturn onInteract main hand");
                }
                LeashReturn.leash(InteractionHand.MAIN_HAND, event);
            }
            if (event.getHand().equals((Object)InteractionHand.OFF_HAND)) {
                if (CowboyUp.debug) {
                    LOGGER.info("LeashReturn onInteract off hand");
                }
                LeashReturn.leash(InteractionHand.OFF_HAND, event);
            }
        }
    }

    private static void leash(InteractionHand hand, PlayerInteractEvent.EntityInteract event) {
        Boolean leashReturn = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        ItemStack heldItem = event.getPlayer().m_21120_(hand);
        Entity target = event.getTarget();
        Player player = event.getPlayer();
        boolean leashed = ((Animal)target).m_21523_();
        Entity leashholder = ((Animal)target).m_21524_();
        if (leashReturn.booleanValue()) {
            if (leashed && leashholder != null && LeashReturn.mc.f_91073_ != null) {
                if (CowboyUp.debug) {
                    LOGGER.info("remove leash " + hand.name());
                }
                ((Animal)target).m_21455_(true, false);
                player.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42655_));
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            } else if (heldItem.m_41720_().equals(Items.f_42655_)) {
                if (CowboyUp.debug) {
                    LOGGER.info("add leash " + hand.name());
                }
                ((Animal)target).m_21463_((Entity)player, true);
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_150109_().m_36057_(heldItem);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
        if (target.m_6095_() == EntityType.f_20457_ || target.m_6095_() == EntityType.f_20560_ || target.m_6095_() == EntityType.f_20503_) {
            HorseStays.stayCmd(leashed, (AbstractHorse)target);
        }
    }

    public static void onKeyInput() {
        Boolean leashReturns = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
        if (KeyBindings.KEYBINDINGS[2].m_90857_()) {
            if (leashReturns.booleanValue() == LeashReturnCommand.ENABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.leashReturns.set((Object)LeashReturnCommand.DISABLED.getBooleanCode());
            } else if (leashReturns.booleanValue() == LeashReturnCommand.DISABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.leashReturns.set((Object)LeashReturnCommand.ENABLED.getBooleanCode());
            }
            LeashReturn.status();
        }
    }

    private static void status() {
        if (((Boolean)CowboyUpConfig.COMMON.reportStatus.get()).booleanValue() && Minecraft.m_91087_().m_91302_() && !Minecraft.m_91087_().m_91104_()) {
            Boolean leashReturns = (Boolean)CowboyUpConfig.COMMON.leashReturns.get();
            String m = ChatFormatting.DARK_AQUA + "[" + ChatFormatting.YELLOW + "CowboyUp" + ChatFormatting.DARK_AQUA + "] ";
            m = leashReturns.booleanValue() == LeashReturnCommand.DISABLED.getBooleanCode() ? m + ChatFormatting.RED + I18n.m_118938_((String)LeashReturnCommand.DISABLED.getDesc(), (Object[])new Object[0]) : m + ChatFormatting.GREEN + I18n.m_118938_((String)LeashReturnCommand.ENABLED.getDesc(), (Object[])new Object[0]);
            if (LeashReturn.mc.f_91074_ != null) {
                LeashReturn.mc.f_91074_.m_6352_((Component)new TextComponent(m), Util.f_137441_);
            }
        }
    }

    public static enum LeashReturnCommand {
        DISABLED(0, "msg.cowboyup.LeashReturns.disabled"),
        ENABLED(1, "msg.cowboyup.LeashReturns.enabled");

        private final int levelCode;
        private final String desc;

        private LeashReturnCommand(int levelCode, String desc) {
            this.levelCode = levelCode;
            this.desc = desc;
        }

        public boolean getBooleanCode() {
            return this.levelCode != 0;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

