/*
 * Decompiled with CFR 0.152.
 */
package frakier.cowboyup.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="cowboyup", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CowboyUpConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMONSPEC;
    private static final Logger LOGGER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configevent) {
    }

    static {
        LOGGER = LogManager.getLogger();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        COMMONSPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue reportStatus;
        public final ForgeConfigSpec.BooleanValue horseCanSwimWithRider;
        public final ForgeConfigSpec.BooleanValue horseStaysCommand;
        public final ForgeConfigSpec.BooleanValue leashReturns;
        public final ForgeConfigSpec.ConfigValue<Integer> swimTime;
        public final ForgeConfigSpec.ConfigValue<Double> swimSpeed;
        public final ForgeConfigSpec.ConfigValue<Double> wadeSpeed;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.reportStatus = builder.comment("Report status of CowboyUp options.").define("reportStatus", true);
            builder.pop();
            builder.push("swim options");
            this.horseCanSwimWithRider = builder.comment("Horse can swim with a rider?").define("horseSwimWithRider", true);
            this.swimTime = builder.comment("Time before horse tires out when swimming in deep water.").define("swimTime", (Object)30);
            this.swimSpeed = builder.comment("Swim speed in deep water [2 deep or more].").define("swimSpeed", (Object)1.01);
            this.wadeSpeed = builder.comment("Wading speed in shallow water [1 deep].").define("wadeSpeed", (Object)1.05);
            builder.pop();
            builder.push("stay options");
            this.horseStaysCommand = builder.comment("Horse stays when dismounted or unleashed?").define("horseStaysCommand", true);
            builder.pop();
            builder.push("leash options");
            this.leashReturns = builder.comment("Catch the lead when unleashing / removing leads?").define("leashReturn", true);
            builder.pop();
        }
    }
}

