/*
 * Decompiled with CFR 0.152.
 */
package frakier.cowboyup.worker;

import frakier.cowboyup.CowboyUp;
import frakier.cowboyup.config.CowboyUpConfig;
import frakier.cowboyup.init.KeyBindings;
import frakier.cowboyup.worker.helper.HorseWorkerHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorseSwim {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final Logger LOGGER = LogManager.getLogger();
    static BlockPos FeetWetPos = new BlockPos(0, 0, 0);
    static Boolean swimmingWithPlayer = false;
    private static boolean falling = false;
    private static double swimTimer = 0.0;
    private static int swimTicks = 0;
    private static Integer swimTime = 0;
    private static boolean swimTimerChanged;

    public static void init() {
        if (CowboyUp.debug) {
            LOGGER.info("HorseSwim init");
        }
        HorseSwim.status();
    }

    public static void TickEvent(TickEvent.PlayerTickEvent event) {
        if (CowboyUp.debug) {
            LOGGER.info("HorseSwim tickevent");
        }
        Boolean horseSwimsWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
        swimTime = (Integer)CowboyUpConfig.COMMON.swimTime.get();
        if (horseSwimsWithRider.booleanValue()) {
            boolean watersEdge;
            AbstractHorseEntity horse = (AbstractHorseEntity)event.player.func_184187_bx();
            BlockPos underHorseBlock = horse.func_180425_c().func_177982_a(0, -1, 0);
            boolean solidUnderHorse = HorseSwim.mc.field_71441_e.func_180495_p(underHorseBlock).func_185904_a().func_76220_a();
            boolean inFluid = HorseSwim.mc.field_71441_e.func_180495_p(horse.func_180425_c()).func_185904_a().func_76224_d();
            boolean eyesInFluid = HorseWorkerHelpers.areEyesInAnyFuid((Entity)horse);
            BlockPos nextStepBlock = horse.func_180425_c().func_177967_a(horse.func_174811_aO(), 1);
            boolean nextStep = HorseSwim.mc.field_71441_e.func_180495_p(nextStepBlock).func_185904_a().func_76220_a();
            float moveSpeed = horse.func_70689_ay();
            if (CowboyUp.debug) {
                LOGGER.info("solidUnderHorse " + solidUnderHorse + " inFluid " + inFluid + " eyesInFluid " + eyesInFluid);
            }
            boolean dryLand = !inFluid && solidUnderHorse;
            boolean wading = inFluid && solidUnderHorse && !eyesInFluid;
            boolean swimming = inFluid && !solidUnderHorse && !eyesInFluid;
            boolean underWater = inFluid && eyesInFluid;
            boolean bl = watersEdge = inFluid && nextStep;
            if (CowboyUp.debug) {
                LOGGER.info("dryLand " + dryLand + " wading " + wading + " swimming " + swimming + " underWater " + underWater + " watersEdge " + watersEdge);
            }
            if (horse.field_70143_R > 4.0f) {
                falling = true;
            }
            if (underWater) {
                falling = false;
                if (horse.func_184207_aI()) {
                    horse.func_184210_p();
                }
            }
            if (dryLand) {
                falling = false;
                swimmingWithPlayer = false;
                swimTimer = 0.0;
            }
            if (CowboyUp.debug) {
                LOGGER.info("dryLand " + dryLand + " wading " + wading + " swimming " + swimming + " underWater " + underWater + " watersEdge " + watersEdge + " falling " + falling);
            }
            if (CowboyUp.debug) {
                LOGGER.info("moveSpeed " + moveSpeed + " horse.getMotion(): " + horse.func_213322_ci().func_82615_a() + ":" + horse.func_213322_ci().func_82616_c() + ":" + horse.func_213322_ci().func_82617_b());
            }
            if (!falling && !eyesInFluid) {
                if (CowboyUp.debug) {
                    LOGGER.info("moveSpeed " + moveSpeed + " swimming " + swimming + " wading" + wading);
                }
                if (swimming && swimTimer <= (double)swimTime.intValue()) {
                    double deepWaterVelocity = 0.9;
                    if (CowboyUp.debug) {
                        LOGGER.info("deepwater speed: " + deepWaterVelocity);
                    }
                    horse.func_213317_d(horse.func_213322_ci().func_216372_d(deepWaterVelocity, 0.0, deepWaterVelocity));
                    HorseSwim.advanceSwimTimer(horse);
                } else if (wading) {
                    // empty if block
                }
            }
            if (watersEdge) {
                boolean jumping = horse.func_110246_bZ();
                if (watersEdge && !jumping) {
                    horse.func_213352_e(new Vec3d((Vec3i)nextStepBlock));
                }
            }
        }
    }

    public static void advanceSwimTimer(AbstractHorseEntity horse) {
        if (CowboyUp.debug) {
            LOGGER.info("swimming " + swimmingWithPlayer + " time left:" + swimTimer);
        }
        if (CowboyUp.debug) {
            LOGGER.info("time left:" + ((double)swimTime.intValue() - swimTimer));
        }
        if (!swimmingWithPlayer.booleanValue()) {
            swimmingWithPlayer = true;
            FeetWetPos = horse.func_180425_c();
            swimTimer = 0.0;
        } else if (FeetWetPos.func_218139_n((Vec3i)horse.func_180425_c()) > 1 || swimTicks > 30) {
            FeetWetPos = horse.func_180425_c();
            swimTimer += 1.0;
            swimTimerChanged = true;
            swimTicks = 0;
        } else {
            ++swimTicks;
        }
        if (swimTimerChanged) {
            swimTimerChanged = false;
        }
    }

    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Boolean horseSwimWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
        if (KeyBindings.KEYBINDINGS[0].func_151468_f()) {
            if (horseSwimWithRider.booleanValue() == HorseSwimsWithRider.ENABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.horseCanSwimWithRider.set((Object)HorseSwimsWithRider.DISABLED.getBooleanCode());
            } else if (horseSwimWithRider.booleanValue() == HorseSwimsWithRider.DISABLED.getBooleanCode()) {
                CowboyUpConfig.COMMON.horseCanSwimWithRider.set((Object)HorseSwimsWithRider.ENABLED.getBooleanCode());
            }
            HorseSwim.status();
        }
    }

    private static void status() {
        if (((Boolean)CowboyUpConfig.COMMON.reportStatus.get()).booleanValue() && Minecraft.func_71410_x().func_195544_aj() && !Minecraft.func_71410_x().func_147113_T()) {
            Boolean horseSwimWithRider = (Boolean)CowboyUpConfig.COMMON.horseCanSwimWithRider.get();
            String m = TextFormatting.DARK_AQUA + "[" + TextFormatting.YELLOW + "CowboyUp" + TextFormatting.DARK_AQUA + "] ";
            m = horseSwimWithRider.booleanValue() == HorseSwimsWithRider.DISABLED.getBooleanCode() ? m + TextFormatting.RED + I18n.func_135052_a((String)HorseSwimsWithRider.DISABLED.getDesc(), (Object[])new Object[0]) : m + TextFormatting.GREEN + I18n.func_135052_a((String)HorseSwimsWithRider.ENABLED.getDesc(), (Object[])new Object[0]);
            HorseSwim.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(m));
        }
    }

    public static enum HorseSwimsWithRider {
        DISABLED(0, "msg.CowboyUp.HorseSwimsWithRider.disbaled"),
        ENABLED(1, "msg.CowboyUp.HorseSwimsWithRider.enabled");

        private final int levelCode;
        private final String desc;

        private HorseSwimsWithRider(int levelCode, String desc) {
            this.levelCode = levelCode;
            this.desc = desc;
        }

        public boolean getBooleanCode() {
            return this.levelCode != 0;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

