/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtquark.blocks;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import maxhyper.dtquark.blocks.SlabRootyBlock;
import maxhyper.dtquark.blocks.StairsRootyBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ResourceLocation;
import vazkii.quark.content.building.block.VerticalSlabBlock;

public class SlabSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE_HOR = TypedRegistry.newType(r -> new SlabSoilProperties((ResourceLocation)r, BlockType.HORIZONTAL));
    public static final TypedRegistry.EntryType<SoilProperties> TYPE_VER = TypedRegistry.newType(r -> new SlabSoilProperties((ResourceLocation)r, BlockType.VERTICAL));
    public static final TypedRegistry.EntryType<SoilProperties> TYPE_STA = TypedRegistry.newType(r -> new SlabSoilProperties((ResourceLocation)r, BlockType.STAIRS));
    private final BlockType slabType;

    public SlabSoilProperties(ResourceLocation registryName, BlockType type) {
        super(registryName);
        this.slabType = type;
    }

    protected RootyBlock createBlock(AbstractBlock.Properties blockProperties) {
        switch (this.slabType) {
            case HORIZONTAL: {
                return new SlabRootyBlock(this, blockProperties);
            }
            case STAIRS: {
                return new StairsRootyBlock(this, blockProperties);
            }
        }
        return new RootyBlock((SoilProperties)this, blockProperties);
    }

    public boolean isValidState(BlockState primitiveSoilState) {
        switch (this.slabType) {
            default: {
                if (!primitiveSoilState.func_235901_b_((Property)SlabBlock.field_196505_a)) break;
                return primitiveSoilState.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP || primitiveSoilState.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE;
            }
            case VERTICAL: {
                if (!primitiveSoilState.func_235901_b_((Property)VerticalSlabBlock.TYPE)) break;
                return primitiveSoilState.func_177229_b((Property)VerticalSlabBlock.TYPE) == VerticalSlabBlock.VerticalSlabType.DOUBLE;
            }
            case STAIRS: {
                if (!primitiveSoilState.func_235901_b_((Property)StairsBlock.field_176308_b)) break;
                return primitiveSoilState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
            }
        }
        return super.isValidState(primitiveSoilState);
    }

    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        BlockState state = super.getSoilState(primitiveSoilState, fertility, requireTileEntity);
        switch (this.slabType) {
            case HORIZONTAL: {
                return (BlockState)((BlockState)state.func_206870_a(SlabRootyBlock.TYPE, (Comparable)((Object)SlabRootyBlock.SlabTypeNoBottom.valueOf(((SlabType)primitiveSoilState.func_177229_b((Property)SlabBlock.field_196505_a)).toString().toUpperCase())))).func_206870_a((Property)SlabRootyBlock.WATERLOGGED, primitiveSoilState.func_177229_b((Property)SlabBlock.field_204512_b));
            }
            case STAIRS: {
                return (BlockState)((BlockState)state.func_206870_a((Property)StairsRootyBlock.FACING, primitiveSoilState.func_177229_b((Property)StairsBlock.field_176309_a))).func_206870_a((Property)StairsRootyBlock.WATERLOGGED, primitiveSoilState.func_177229_b((Property)StairsBlock.field_204513_t));
            }
        }
        return state;
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        BlockState primitiveSoilState = super.getPrimitiveSoilState(currentSoilState);
        switch (this.slabType) {
            default: {
                if (!primitiveSoilState.func_235901_b_((Property)SlabBlock.field_196505_a)) break;
                return (BlockState)((BlockState)primitiveSoilState.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.valueOf((String)((SlabRootyBlock.SlabTypeNoBottom)((Object)currentSoilState.func_177229_b(SlabRootyBlock.TYPE))).toString().toUpperCase()))).func_206870_a((Property)SlabBlock.field_204512_b, currentSoilState.func_177229_b((Property)SlabRootyBlock.WATERLOGGED));
            }
            case VERTICAL: {
                if (!primitiveSoilState.func_235901_b_((Property)VerticalSlabBlock.TYPE)) break;
                return (BlockState)primitiveSoilState.func_206870_a((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE);
            }
            case STAIRS: {
                if (!primitiveSoilState.func_235901_b_((Property)StairsBlock.field_176308_b) || !primitiveSoilState.func_235901_b_((Property)StairsBlock.field_176309_a)) break;
                return (BlockState)((BlockState)((BlockState)primitiveSoilState.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176309_a, currentSoilState.func_177229_b((Property)StairsRootyBlock.FACING))).func_206870_a((Property)StairsBlock.field_204513_t, currentSoilState.func_177229_b((Property)StairsRootyBlock.WATERLOGGED));
            }
        }
        return primitiveSoilState;
    }

    private static enum BlockType {
        VERTICAL,
        HORIZONTAL,
        STAIRS;

    }
}

