/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DataUnserializedCompound
implements Data<DataUnserializedCompound, CompoundNBT> {
    private final Map<String, Data<?, ?>> serialized = new HashMap();
    private final CompoundNBT unserializedNBT;

    public DataUnserializedCompound(CompoundNBT nbt) {
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        this.unserializedNBT = nbt.func_74737_b();
    }

    protected <T extends Data<?, ?>> T add(String key, T data) {
        this.serialized.put(key, data);
        this.unserializedNBT.func_82580_o(key);
        return data;
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = this.unserializedNBT.func_74737_b();
        for (String key : this.serialized.keySet()) {
            Data<?, ?> data = this.serialized.get(key);
            if (data.isDefault()) continue;
            nbt.func_218657_a(key, data.getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (this.serialized.isEmpty() || this.isDefault()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        ArrayList collection = Lists.newArrayList(this.serialized.keySet());
        ArrayList list = Lists.newArrayList();
        for (String s : collection) {
            Data<?, ?> d = this.serialized.get(s);
            if (d.isDefault()) continue;
            list.add(s);
        }
        Collections.sort(list);
        collection = list;
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(s)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.serialized.get(s).getPrettyDisplay(space, indentation + 1));
            if (iterator.hasNext()) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    @Override
    public boolean isDefault() {
        if (!this.unserializedNBT.isEmpty()) {
            return false;
        }
        for (String key : this.serialized.keySet()) {
            Data<?, ?> data = this.serialized.get(key);
            if (data.isDefault()) continue;
            return false;
        }
        return true;
    }

    @Override
    public DataUnserializedCompound getData() {
        return this;
    }
}

