/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.base;

import infinityitemeditor.data.Data;
import infinityitemeditor.util.ColorUtils;
import java.awt.Color;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DataColor
extends ColorUtils.Color
implements Data<ColorUtils.Color, IntNBT> {
    private int defColor = 0;
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float brightness = 0.0f;

    public DataColor(INBT nbt) {
        this(nbt instanceof IntNBT ? (IntNBT)nbt : IntNBT.func_229692_a_((int)0));
    }

    public DataColor(IntNBT nbt) {
        this(nbt.func_150287_d());
    }

    public DataColor(int color) {
        super(color);
    }

    @Override
    public boolean isDefault() {
        return this.argb == this.defColor;
    }

    @Override
    public ColorUtils.Color getData() {
        return this;
    }

    @Override
    public IntNBT getNBT() {
        return IntNBT.func_229692_a_((int)this.argb);
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        IFormattableTextComponent itextcomponent = new StringTextComponent(this.getHexString().substring(1)).func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER);
        return new StringTextComponent("#").func_230529_a_((ITextComponent)itextcomponent).func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    }

    private void updateHSB() {
        float[] hsb = this.getHSB();
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public ColorUtils.Color setHSB(float h, float s, float b) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        return super.setInt(Color.HSBtoRGB(h, s, b));
    }

    @Override
    public ColorUtils.Color setInt(int color) {
        super.setInt(color);
        this.updateHSB();
        return this;
    }

    public int getDefColor() {
        return this.defColor;
    }

    public void setDefColor(int defColor) {
        this.defColor = defColor;
    }

    @Override
    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }
}

