/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataDouble;
import infinityitemeditor.data.base.DataString;
import infinityitemeditor.data.tag.TagEnum;
import infinityitemeditor.data.version.NBTKeys;
import infinityitemeditor.util.AttributeUtils;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;

public class TagAttributeModifier
implements Data<TagAttributeModifier, CompoundNBT> {
    private Attribute attribute;
    private final DataString name;
    private final DataDouble amount;
    private final TagEnum<AttributeModifier.Operation> operation;
    private final TagEnum<EquipmentSlotType> slot;

    public TagAttributeModifier(Map.Entry<RegistryKey<Attribute>, Attribute> attributeRegistryEntry) {
        this(attributeRegistryEntry.getValue(), new AttributeModifier(attributeRegistryEntry.getKey().toString(), attributeRegistryEntry.getValue().func_111110_b(), AttributeModifier.Operation.ADDITION), null);
    }

    public TagAttributeModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotType slot) {
        this.attribute = attribute;
        this.name = new DataString(modifier.func_111166_b());
        this.amount = new DataDouble(modifier.func_111164_d());
        this.operation = new TagEnum<AttributeModifier.Operation>(AttributeModifier.Operation.class, modifier.func_220375_c());
        this.slot = new TagEnum<EquipmentSlotType>(EquipmentSlotType.class, slot);
    }

    public TagAttributeModifier(INBT nbt) {
        this(nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT());
    }

    public TagAttributeModifier(CompoundNBT nbt) {
        this(AttributeUtils.getAttribute(nbt.func_74779_i(NBTKeys.keys.attributeName())), AttributeModifier.func_233800_a_((CompoundNBT)nbt), nbt.func_150297_b(NBTKeys.keys.attributeSlot(), 8) ? EquipmentSlotType.func_188451_a((String)nbt.func_74779_i(NBTKeys.keys.attributeSlot())) : EquipmentSlotType.MAINHAND);
    }

    @Override
    public TagAttributeModifier getData() {
        return this;
    }

    @Override
    public boolean isDefault() {
        return this.attribute == null || (Double)this.amount.get() == 0.0 || this.getNBT().isEmpty();
    }

    @Override
    public CompoundNBT getNBT() {
        if (this.attribute == null) {
            return new CompoundNBT();
        }
        CompoundNBT nbt = this.createAttributeModifier().func_233801_e_();
        nbt.func_74778_a(NBTKeys.keys.attributeName(), AttributeUtils.getName(this.attribute));
        nbt.func_74778_a(NBTKeys.keys.attributeSlot(), ((EquipmentSlotType)this.slot.get()).func_188450_d());
        return nbt;
    }

    public AttributeModifier createAttributeModifier() {
        return new AttributeModifier((String)this.name.get(), ((Double)this.amount.get()).doubleValue(), (AttributeModifier.Operation)this.operation.get());
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return ((TextComponent)this.slot.getPrettyDisplay("", 0)).func_230529_a_((ITextComponent)AttributeUtils.getText(this.getAttribute(), this.createAttributeModifier()));
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public DataString getName() {
        return this.name;
    }

    public DataDouble getAmount() {
        return this.amount;
    }

    public TagEnum<AttributeModifier.Operation> getOperation() {
        return this.operation;
    }

    public TagEnum<EquipmentSlotType> getSlot() {
        return this.slot;
    }
}

