/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.DataColor;
import infinityitemeditor.data.base.DataListString;
import infinityitemeditor.data.tag.TagDisplayName;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;

public class TagDisplay
implements Data<TagDisplay, CompoundNBT> {
    private final DataItem item;
    private final DataColor color;
    private final DataColor mapColor;
    private final TagDisplayName name;
    private final DataListString lore;

    public TagDisplay(DataItem item, CompoundNBT nbt) {
        this.item = item;
        NBTKeys keys = NBTKeys.keys;
        this.color = new DataColor(nbt.func_74762_e(keys.displayColor()));
        this.mapColor = new DataColor(nbt.func_74762_e(keys.displayMapColor()));
        this.name = new TagDisplayName(nbt.func_74779_i(keys.displayName()), this.item);
        this.lore = new DataListString(nbt.func_150295_c(keys.displayLore(), 8));
    }

    @Override
    public boolean isDefault() {
        return this.color.isDefault() && this.mapColor.isDefault() && this.name.isDefault() && this.lore.isDefault();
    }

    @Override
    public CompoundNBT getNBT() {
        NBTKeys keys = NBTKeys.keys;
        CompoundNBT nbt = new CompoundNBT();
        if (!this.color.isDefault()) {
            nbt.func_218657_a(keys.displayColor(), (INBT)this.color.getNBT());
        }
        if (!this.mapColor.isDefault()) {
            nbt.func_218657_a(keys.displayMapColor(), (INBT)this.mapColor.getNBT());
        }
        if (!this.name.isDefault()) {
            nbt.func_218657_a(keys.displayName(), (INBT)this.name.getNBT());
        }
        if (!this.lore.isDefault()) {
            nbt.func_218657_a(keys.displayLore(), (INBT)this.lore.getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return this.getNBT().func_199850_a(space, indentation);
    }

    @Override
    public TagDisplay getData() {
        return this;
    }

    public DataColor getColor() {
        return this.color;
    }

    public DataColor getMapColor() {
        return this.mapColor;
    }

    public TagDisplayName getName() {
        return this.name;
    }

    public DataListString getLore() {
        return this.lore;
    }
}

