/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataBoolean;
import infinityitemeditor.data.base.DataByte;
import infinityitemeditor.data.base.DataInteger;
import infinityitemeditor.data.tag.TagEffectId;
import infinityitemeditor.util.EffectUtils;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;

public class TagEffect
implements Data<EffectInstance, CompoundNBT> {
    private final TagEffectId effectId;
    private final DataByte amplifier;
    private final DataInteger duration;
    private final DataBoolean ambient;
    private final DataBoolean showParticles;
    private final DataBoolean showIcon;

    public TagEffect(INBT nbt) {
        this(nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT());
    }

    public TagEffect(CompoundNBT nbt) {
        this.effectId = new TagEffectId(nbt.func_74771_c("Id"));
        this.amplifier = new DataByte(nbt.func_74771_c("Amplifier"));
        this.duration = new DataInteger(nbt.func_74762_e("Duration"));
        this.ambient = new DataBoolean(nbt.func_74767_n("Ambient"));
        this.showParticles = new DataBoolean(nbt.func_74767_n("ShowParticles"));
        this.showIcon = new DataBoolean(nbt.func_74767_n("ShowIcon"));
    }

    public TagEffect(Map.Entry<RegistryKey<Effect>, Effect> registryEntry) {
        this.effectId = new TagEffectId((byte)Effect.func_188409_a((Effect)registryEntry.getValue()));
        this.amplifier = new DataByte(1);
        this.duration = new DataInteger(1);
        this.ambient = new DataBoolean(false);
        this.showParticles = new DataBoolean(false);
        this.showIcon = new DataBoolean(false);
    }

    @Override
    public EffectInstance getData() {
        return EffectInstance.func_82722_b((CompoundNBT)this.getNBT());
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Id", (INBT)this.effectId.getNBT());
        if ((Byte)this.amplifier.get() > 1) {
            nbt.func_218657_a("Amplifier", (INBT)this.amplifier.getNBT());
        }
        if ((Integer)this.duration.get() > 1) {
            nbt.func_218657_a("Duration", (INBT)this.duration.getNBT());
        }
        if (!((Boolean)this.ambient.get()).booleanValue()) {
            nbt.func_218657_a("Ambient", (INBT)this.ambient.getNBT());
        }
        if (!((Boolean)this.showParticles.get()).booleanValue()) {
            nbt.func_218657_a("ShowParticles", (INBT)this.showParticles.getNBT());
        }
        if (!((Boolean)this.showIcon.get()).booleanValue()) {
            nbt.func_218657_a("ShowIcon", (INBT)this.showIcon.getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return EffectUtils.getText(this);
    }

    public TagEffectId getEffectId() {
        return this.effectId;
    }

    public DataByte getAmplifier() {
        return this.amplifier;
    }

    public DataInteger getDuration() {
        return this.duration;
    }

    public DataBoolean getAmbient() {
        return this.ambient;
    }

    public DataBoolean getShowParticles() {
        return this.showParticles;
    }

    public DataBoolean getShowIcon() {
        return this.showIcon;
    }
}

