/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.base.SingularData;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TagEnum<E extends Enum<E>>
extends SingularData<E, IntNBT>
implements Button.IPressable {
    private final E[] options;

    public TagEnum(Class<E> clazz, E value) {
        super(value);
        this.options = (Enum[])clazz.getEnumConstants();
        if (this.data == null) {
            this.data = this.options[0];
        }
    }

    public void next() {
        this.set(this.options[(((Enum)this.data).ordinal() + 1) % this.options.length]);
    }

    public void previous() {
        this.set(this.options[(((Enum)this.data).ordinal() - 1) % this.options.length]);
    }

    @Override
    public boolean isDefault() {
        return this.data == null;
    }

    @Override
    public IntNBT getNBT() {
        return IntNBT.func_229692_a_((int)((Enum)this.data).ordinal());
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return this.getName().func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    public void onPress(Button button) {
        this.next();
        button.func_238482_a_((ITextComponent)this.getName());
    }

    public TextComponent getName() {
        return new TranslationTextComponent("enum." + (((Enum)this.data).getDeclaringClass().getSimpleName() + '.' + ((Enum)this.data).name()).toLowerCase());
    }

    public TextComponent getKeyValue() {
        return (TextComponent)new TranslationTextComponent("enum." + ((Enum)this.data).getDeclaringClass().getSimpleName().toLowerCase() + "._", new Object[]{this.getPrettyDisplay("", 0)}).func_240699_a_(TextFormatting.AQUA);
    }

    public E[] getOptions() {
        return this.options;
    }
}

