/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataBoolean;
import infinityitemeditor.data.base.DataColor;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TagExplosion
implements Data<TagExplosion, CompoundNBT> {
    private final DataBoolean flicker;
    private final DataBoolean trail;
    private FireworkRocketItem.Shape shape;
    private final TagList<DataColor> colors;
    private final TagList<DataColor> fadeColors;

    public TagExplosion(INBT nbt) {
        this(nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT());
    }

    public TagExplosion(CompoundNBT nbt) {
        NBTKeys keys = NBTKeys.keys;
        this.flicker = new DataBoolean(nbt.func_74767_n(keys.explosionFlicker()));
        this.trail = new DataBoolean(nbt.func_74767_n(keys.explosionTrail()));
        this.shape = FireworkRocketItem.Shape.func_196070_a((int)nbt.func_74771_c(keys.explosionShape()));
        this.colors = new TagList<DataColor>(nbt.func_150295_c(keys.explosionColors(), 3), DataColor::new);
        this.fadeColors = new TagList<DataColor>(nbt.func_150295_c(keys.explosionFadeColor(), 3), DataColor::new);
    }

    @Override
    public TagExplosion getData() {
        return this;
    }

    @Override
    public boolean isDefault() {
        return this.flicker.isDefault() && this.trail.isDefault() && (this.shape == null || this.shape.ordinal() == 0) && this.colors.isDefault() && this.fadeColors.isDefault();
    }

    @Override
    public CompoundNBT getNBT() {
        NBTKeys keys = NBTKeys.keys;
        CompoundNBT nbt = new CompoundNBT();
        if (!this.flicker.isDefault()) {
            nbt.func_218657_a(keys.explosionFlicker(), (INBT)this.flicker.getNBT());
        }
        if (!this.trail.isDefault()) {
            nbt.func_218657_a(keys.explosionTrail(), (INBT)this.trail.getNBT());
        }
        if (this.shape != null) {
            nbt.func_218657_a(keys.explosionShape(), (INBT)ByteNBT.func_229671_a_((byte)((byte)this.shape.ordinal())));
        }
        if (!this.colors.isDefault()) {
            nbt.func_218657_a(keys.explosionColors(), (INBT)this.colors.getNBT());
        }
        if (!this.getFadeColors().isDefault()) {
            nbt.func_218657_a(keys.explosionFadeColor(), (INBT)this.fadeColors.getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (this.isDefault() || this.shape == null) {
            return new StringTextComponent("{}");
        }
        return new StringTextComponent(this.shape.func_196068_b()).func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
    }

    public DataBoolean getFlicker() {
        return this.flicker;
    }

    public DataBoolean getTrail() {
        return this.trail;
    }

    public FireworkRocketItem.Shape getShape() {
        return this.shape;
    }

    public void setShape(FireworkRocketItem.Shape shape) {
        this.shape = shape;
    }

    public TagList<DataColor> getColors() {
        return this.colors;
    }

    public TagList<DataColor> getFadeColors() {
        return this.fadeColors;
    }
}

