/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import com.google.common.base.Strings;
import infinityitemeditor.data.base.DataByte;
import infinityitemeditor.data.base.DataMap;
import infinityitemeditor.data.base.SingularData;
import infinityitemeditor.data.tag.TagExplosion;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TagFirework
extends SingularData<TagList<TagExplosion>, CompoundNBT> {
    private final DataByte flight;

    public TagFirework(CompoundNBT nbt) {
        this(new TagList<TagExplosion>(nbt.func_150295_c(NBTKeys.keys.fireworksExplosions(), 10), TagExplosion::new), nbt.func_74771_c(NBTKeys.keys.fireworksFlight()));
    }

    public TagFirework(TagList<TagExplosion> list, byte flight) {
        super(list);
        this.flight = new DataByte(flight);
    }

    @Override
    public boolean isDefault() {
        return ((TagList)this.data).isDefault();
    }

    @Override
    public CompoundNBT getNBT() {
        NBTKeys keys = NBTKeys.keys;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(keys.fireworksFlight(), (INBT)this.flight.getNBT());
        nbt.func_218657_a(keys.fireworksExplosions(), (INBT)((TagList)this.data).getNBT());
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (this.isDefault()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        NBTKeys keys = NBTKeys.keys;
        String explosions = keys.fireworksExplosions();
        String flight = keys.fireworksFlight();
        IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(explosions)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(((TagList)this.data).getPrettyDisplay(space, indentation + 1));
        iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
        iformattabletextcomponent1.func_240702_b_(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(flight)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.flight.getPrettyDisplay(space, indentation + 1));
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    public DataByte getFlight() {
        return this.flight;
    }
}

