/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.base.DataString;
import javax.annotation.Nonnull;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TagItemID
extends DataString {
    public TagItemID(INBT value) {
        this(value instanceof StringNBT ? value.func_150285_a_() : "air");
    }

    public TagItemID(String value) {
        super(value);
    }

    public TagItemID(Item item) {
        this(TagItemID.getIDFromItem(item));
        this.data = this.getIDExcludingMC();
    }

    public TagItemID() {
        this(Items.field_190931_a);
    }

    @Nonnull
    public Item getItem() {
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation((String)this.get()));
        return item != null ? item : Items.field_190931_a;
    }

    public String getIDExcludingMC() {
        if (this.data == null) {
            return "air";
        }
        if (((String)this.data).startsWith("minecraft:")) {
            return ((String)this.data).substring(10);
        }
        return (String)this.data;
    }

    public boolean isBlockItem() {
        return this.getItem() instanceof BlockItem;
    }

    public void setItem(Item item) {
        this.set(TagItemID.getIDFromItem(item));
    }

    public static String getIDFromItem(Item item) {
        return item != null ? item.getRegistryName().toString() : "minecraft:air";
    }

    @Override
    public boolean isDefault() {
        return false;
    }
}

