/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.SingularData;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TagList<E extends Data<?, ?>>
extends SingularData<List<E>, ListNBT>
implements Iterable<E> {
    protected Function<INBT, E> addFunction;

    public TagList(Function<INBT, E> addFunction) {
        this(Lists.newArrayList());
        this.addFunction = addFunction;
    }

    public TagList(ListNBT nbt, Function<INBT, E> addFunction) {
        this(addFunction);
        nbt.forEach(this::add);
    }

    public TagList(List<E> list) {
        super(list);
    }

    public void add(E value) {
        if (value != null) {
            ((List)this.data).add(value);
        }
    }

    public void add(INBT nbt) {
        this.add((Data)this.addFunction.apply(nbt));
    }

    public void remove(E value) {
        ((List)this.data).remove(value);
    }

    public void remove(int index) {
        ((List)this.data).remove(index);
    }

    public void clear() {
        ((List)this.data).clear();
    }

    @Override
    public boolean isDefault() {
        return ((List)this.data).isEmpty();
    }

    @Override
    public ListNBT getNBT() {
        ListNBT nbt = new ListNBT();
        ((List)this.data).forEach(dat -> {
            if (!dat.isDefault()) {
                nbt.add(dat.getNBT());
            }
        });
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (((List)this.data).isEmpty()) {
            return new StringTextComponent("[]");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("[");
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        String s = String.valueOf(',');
        for (int i = 0; i < ((List)this.data).size(); ++i) {
            StringTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1)));
            iformattabletextcomponent1.func_230529_a_(((Data)((List)this.data).get(i)).getPrettyDisplay(space, indentation + 1));
            if (i != ((List)this.data).size() - 1) {
                iformattabletextcomponent1.func_240702_b_(s).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("]");
        return iformattabletextcomponent;
    }

    @Override
    public ListIterator<E> iterator() {
        return ((List)this.data).listIterator();
    }
}

